/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.kms.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import java.beans.ConstructorProperties;
import java.util.HashMap;

public class EncryptData
implements ModelEntity {
    private static final long serialVersionUID = -6764087311133427927L;
    @JsonProperty(value="key_id")
    String keyId;
    @JsonProperty(value="plain_text")
    String plainText;
    @JsonProperty(value="encryption_context")
    HashMap<String, Object> encryptionContext;
    @JsonProperty(value="sequence")
    String sequence;

    public void addContext(String key, Object value) {
        this.encryptionContext.put(key, value);
    }

    public static EncryptDataBuilder builder() {
        return new EncryptDataBuilder();
    }

    public EncryptDataBuilder toBuilder() {
        return new EncryptDataBuilder().keyId(this.keyId).plainText(this.plainText).encryptionContext(this.encryptionContext).sequence(this.sequence);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public HashMap<String, Object> getEncryptionContext() {
        return this.encryptionContext;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String toString() {
        return "EncryptData(keyId=" + this.getKeyId() + ", plainText=" + this.getPlainText() + ", encryptionContext=" + this.getEncryptionContext() + ", sequence=" + this.getSequence() + ")";
    }

    public EncryptData() {
    }

    @ConstructorProperties(value={"keyId", "plainText", "encryptionContext", "sequence"})
    public EncryptData(String keyId, String plainText, HashMap<String, Object> encryptionContext, String sequence) {
        this.keyId = keyId;
        this.plainText = plainText;
        this.encryptionContext = encryptionContext;
        this.sequence = sequence;
    }

    public static class EncryptDataBuilder {
        private String keyId;
        private String plainText;
        private HashMap<String, Object> encryptionContext;
        private String sequence;

        EncryptDataBuilder() {
        }

        public EncryptDataBuilder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public EncryptDataBuilder plainText(String plainText) {
            this.plainText = plainText;
            return this;
        }

        public EncryptDataBuilder encryptionContext(HashMap<String, Object> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        public EncryptDataBuilder sequence(String sequence) {
            this.sequence = sequence;
            return this;
        }

        public EncryptData build() {
            return new EncryptData(this.keyId, this.plainText, this.encryptionContext, this.sequence);
        }

        public String toString() {
            return "EncryptData.EncryptDataBuilder(keyId=" + this.keyId + ", plainText=" + this.plainText + ", encryptionContext=" + this.encryptionContext + ", sequence=" + this.sequence + ")";
        }
    }
}

