/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.kms.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.openstack.kms.domain.DEK;
import com.huawei.openstack4j.openstack.kms.domain.DecryptDEK;
import com.huawei.openstack4j.openstack.kms.domain.DecryptData;
import com.huawei.openstack4j.openstack.kms.domain.DecryptedDEK;
import com.huawei.openstack4j.openstack.kms.domain.DecryptedData;
import com.huawei.openstack4j.openstack.kms.domain.EncryptDEK;
import com.huawei.openstack4j.openstack.kms.domain.EncryptData;
import com.huawei.openstack4j.openstack.kms.domain.EncryptedDEK;
import com.huawei.openstack4j.openstack.kms.domain.EncryptedData;
import com.huawei.openstack4j.openstack.kms.internal.BaseKeyManagementService;
import java.util.HashMap;

public class CryptoService
extends BaseKeyManagementService
implements RestService {
    public String generateRandomString(String sequence) {
        HashMap entity = Maps.newHashMap();
        entity.put("random_data_length", "512");
        entity.put("sequence", sequence);
        HashMap execute = this.post(HashMap.class, "/kms/gen-random").entity(entity).execute();
        return (String)execute.get("random_data");
    }

    public DEK createDEK(String keyId, HashMap<String, Object> encryptionContext, String sequence) {
        return this.createDEK(keyId, encryptionContext, true, sequence);
    }

    public DEK createDEKWithoutPlaintext(String keyId, HashMap<String, Object> encryptionContext, String sequence) {
        return this.createDEK(keyId, encryptionContext, false, sequence);
    }

    private DEK createDEK(String keyId, HashMap<String, Object> encryptionContext, boolean withPlainText, String sequence) {
        HashMap entity = Maps.newHashMap();
        entity.put("key_id", keyId);
        entity.put("datakey_length", "512");
        if (encryptionContext != null && !encryptionContext.isEmpty()) {
            entity.put("encryption_context", encryptionContext);
        }
        if (!Strings.isNullOrEmpty((String)sequence)) {
            entity.put("sequence", sequence);
        }
        String url = withPlainText ? "/kms/create-datakey" : "/kms/create-datakey-without-plaintext";
        return this.post(DEK.class, url).entity(entity).execute();
    }

    public EncryptedDEK encryptDEK(EncryptDEK encrypt) {
        Preconditions.checkNotNull((Object)encrypt, (Object)"parameter `encrypt` should not be null");
        Preconditions.checkNotNull((Object)encrypt.getKeyId(), (Object)"parameter `encrypt.keyId` should not be null");
        Preconditions.checkNotNull((Object)encrypt.getPlainText(), (Object)"parameter `encrypt.plainText` should not be null");
        if (encrypt.getPlainTextLength() == null) {
            encrypt = encrypt.toBuilder().plainTextLength(64).build();
        }
        byte[] decode = BaseEncoding.base16().lowerCase().decode((CharSequence)encrypt.getPlainText());
        byte[] digest = Hashing.sha256().hashBytes(decode).asBytes();
        String digestText = BaseEncoding.base16().lowerCase().encode(digest);
        encrypt = encrypt.toBuilder().plainText(encrypt.getPlainText() + digestText).build();
        return this.post(EncryptedDEK.class, "/kms/encrypt-datakey").entity(encrypt).execute();
    }

    public DecryptedDEK decryptDEK(DecryptDEK decrypt) {
        Preconditions.checkNotNull((Object)decrypt, (Object)"parameter `decrypt` should not be null");
        Preconditions.checkNotNull((Object)decrypt.getKeyId(), (Object)"parameter `decrypt.keyId` should not be null");
        Preconditions.checkNotNull((Object)decrypt.getCipherText(), (Object)"parameter `decrypt.cipherText` should not be null");
        if (decrypt.getCipherTextLength() == null) {
            decrypt = decrypt.toBuilder().cipherTextLength(64).build();
        }
        return this.post(DecryptedDEK.class, "/kms/decrypt-datakey").entity(decrypt).execute();
    }

    public EncryptedData encryptData(EncryptData encrypt) {
        Preconditions.checkNotNull((Object)encrypt, (Object)"parameter `encrypt` should not be null");
        Preconditions.checkNotNull((Object)encrypt.getKeyId(), (Object)"parameter `encrypt.keyId` should not be null");
        Preconditions.checkNotNull((Object)encrypt.getPlainText(), (Object)"parameter `encrypt.plainText` should not be null");
        encrypt = encrypt.toBuilder().plainText(encrypt.getPlainText()).build();
        return this.post(EncryptedData.class, "/kms/encrypt-data").entity(encrypt).execute();
    }

    public DecryptedData decryptData(DecryptData decrypt) {
        Preconditions.checkNotNull((Object)decrypt, (Object)"parameter `decrypt` should not be null");
        Preconditions.checkNotNull((Object)decrypt.getCipherText(), (Object)"parameter `decrypt.cipherText` should not be null");
        return this.post(DecryptedData.class, "/kms/decrypt-data").entity(decrypt).execute();
    }
}

