/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.loadbalance.Certificate;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;

public class ELBCertificate
implements Certificate {
    private static final long serialVersionUID = 4428629100301469093L;
    private String id;
    private String name;
    private String domain;
    private String description;
    private String certificate;
    @JsonProperty(value="private_key")
    private String privateKey;
    @JsonProperty(value="create_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonProperty(value="update_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    public static ELBCertificateBuilder builder() {
        return new ELBCertificateBuilder();
    }

    public ELBCertificateBuilder toBuilder() {
        return new ELBCertificateBuilder().id(this.id).name(this.name).domain(this.domain).description(this.description).certificate(this.certificate).privateKey(this.privateKey).createTime(this.createTime).updateTime(this.updateTime);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getCertificate() {
        return this.certificate;
    }

    @Override
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String toString() {
        return "ELBCertificate(id=" + this.getId() + ", name=" + this.getName() + ", domain=" + this.getDomain() + ", description=" + this.getDescription() + ", certificate=" + this.getCertificate() + ", privateKey=" + this.getPrivateKey() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }

    public ELBCertificate() {
    }

    @ConstructorProperties(value={"id", "name", "domain", "description", "certificate", "privateKey", "createTime", "updateTime"})
    public ELBCertificate(String id, String name, String domain, String description, String certificate, String privateKey, Date createTime, Date updateTime) {
        this.id = id;
        this.name = name;
        this.domain = domain;
        this.description = description;
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    public static class ELBCertificateBuilder {
        private String id;
        private String name;
        private String domain;
        private String description;
        private String certificate;
        private String privateKey;
        private Date createTime;
        private Date updateTime;

        ELBCertificateBuilder() {
        }

        public ELBCertificateBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ELBCertificateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ELBCertificateBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public ELBCertificateBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ELBCertificateBuilder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public ELBCertificateBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public ELBCertificateBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public ELBCertificateBuilder updateTime(Date updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ELBCertificate build() {
            return new ELBCertificate(this.id, this.name, this.domain, this.description, this.certificate, this.privateKey, this.createTime, this.updateTime);
        }

        public String toString() {
            return "ELBCertificate.ELBCertificateBuilder(id=" + this.id + ", name=" + this.name + ", domain=" + this.domain + ", description=" + this.description + ", certificate=" + this.certificate + ", privateKey=" + this.privateKey + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ")";
        }
    }

    public static class Certificates {
        private List<ELBCertificate> certificates;
        @JsonProperty(value="instance_num")
        private String instanceNum;

        public static CertificatesBuilder builder() {
            return new CertificatesBuilder();
        }

        public CertificatesBuilder toBuilder() {
            return new CertificatesBuilder().certificates(this.certificates).instanceNum(this.instanceNum);
        }

        public List<ELBCertificate> getCertificates() {
            return this.certificates;
        }

        public String getInstanceNum() {
            return this.instanceNum;
        }

        public String toString() {
            return "ELBCertificate.Certificates(certificates=" + this.getCertificates() + ", instanceNum=" + this.getInstanceNum() + ")";
        }

        public Certificates() {
        }

        @ConstructorProperties(value={"certificates", "instanceNum"})
        public Certificates(List<ELBCertificate> certificates, String instanceNum) {
            this.certificates = certificates;
            this.instanceNum = instanceNum;
        }

        public static class CertificatesBuilder {
            private List<ELBCertificate> certificates;
            private String instanceNum;

            CertificatesBuilder() {
            }

            public CertificatesBuilder certificates(List<ELBCertificate> certificates) {
                this.certificates = certificates;
                return this;
            }

            public CertificatesBuilder instanceNum(String instanceNum) {
                this.instanceNum = instanceNum;
                return this;
            }

            public Certificates build() {
                return new Certificates(this.certificates, this.instanceNum);
            }

            public String toString() {
                return "ELBCertificate.Certificates.CertificatesBuilder(certificates=" + this.certificates + ", instanceNum=" + this.instanceNum + ")";
            }
        }
    }
}

