/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.loadbalance.Listener;
import com.huawei.openstack4j.model.loadbalance.ListenerUpdate;
import java.beans.ConstructorProperties;
import java.util.List;

public class ELBListenerUpdate
implements ListenerUpdate {
    private static final long serialVersionUID = 2402527926955142969L;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private Integer port;
    @JsonProperty(value="backend_port")
    private Integer backendPort;
    @JsonProperty(value="lb_algorithm")
    private Listener.LbAlgorithm lbAlgorithm;
    @JsonProperty(value="tcp_timeout")
    private Integer tcpTimeout;
    @JsonProperty(value="tcp_draining")
    private Boolean tcpDraining;
    @JsonProperty(value="tcp_draining_timeout")
    private Integer tcpDrainingTimeout;
    @JsonProperty(value="udp_timeout")
    private Integer udpTimeout;
    @JsonProperty(value="ssl_protocols")
    private Listener.SSLProtocols sslProtocols;
    @JsonProperty(value="ssl_ciphers")
    private Listener.SSLCiphers sslCiphers;
    @JsonProperty(value="certificate_id")
    private String certificateId;
    private List<String> certificates;

    public static ELBListenerUpdate fromListener(Listener listener) {
        return ELBListenerUpdate.builder().name(listener.getName()).description(listener.getDescription()).port(listener.getPort()).backendPort(listener.getBackendPort()).lbAlgorithm(listener.getLbAlgorithm()).tcpDraining(listener.getTcpDraining()).tcpDrainingTimeout(listener.getTcpDrainingTimeout()).build();
    }

    public static ELBListenerUpdateBuilder builder() {
        return new ELBListenerUpdateBuilder();
    }

    public ELBListenerUpdateBuilder toBuilder() {
        return new ELBListenerUpdateBuilder().name(this.name).description(this.description).port(this.port).backendPort(this.backendPort).lbAlgorithm(this.lbAlgorithm).tcpTimeout(this.tcpTimeout).tcpDraining(this.tcpDraining).tcpDrainingTimeout(this.tcpDrainingTimeout).udpTimeout(this.udpTimeout).sslProtocols(this.sslProtocols).sslCiphers(this.sslCiphers).certificateId(this.certificateId).certificates(this.certificates);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public Integer getBackendPort() {
        return this.backendPort;
    }

    @Override
    public Listener.LbAlgorithm getLbAlgorithm() {
        return this.lbAlgorithm;
    }

    @Override
    public Integer getTcpTimeout() {
        return this.tcpTimeout;
    }

    @Override
    public Boolean getTcpDraining() {
        return this.tcpDraining;
    }

    @Override
    public Integer getTcpDrainingTimeout() {
        return this.tcpDrainingTimeout;
    }

    @Override
    public Integer getUdpTimeout() {
        return this.udpTimeout;
    }

    @Override
    public Listener.SSLProtocols getSslProtocols() {
        return this.sslProtocols;
    }

    @Override
    public Listener.SSLCiphers getSslCiphers() {
        return this.sslCiphers;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public List<String> getCertificates() {
        return this.certificates;
    }

    public String toString() {
        return "ELBListenerUpdate(name=" + this.getName() + ", description=" + this.getDescription() + ", port=" + this.getPort() + ", backendPort=" + this.getBackendPort() + ", lbAlgorithm=" + (Object)((Object)this.getLbAlgorithm()) + ", tcpTimeout=" + this.getTcpTimeout() + ", tcpDraining=" + this.getTcpDraining() + ", tcpDrainingTimeout=" + this.getTcpDrainingTimeout() + ", udpTimeout=" + this.getUdpTimeout() + ", sslProtocols=" + (Object)((Object)this.getSslProtocols()) + ", sslCiphers=" + (Object)((Object)this.getSslCiphers()) + ", certificateId=" + this.getCertificateId() + ", certificates=" + this.getCertificates() + ")";
    }

    public ELBListenerUpdate() {
    }

    @ConstructorProperties(value={"name", "description", "port", "backendPort", "lbAlgorithm", "tcpTimeout", "tcpDraining", "tcpDrainingTimeout", "udpTimeout", "sslProtocols", "sslCiphers", "certificateId", "certificates"})
    public ELBListenerUpdate(String name, String description, Integer port, Integer backendPort, Listener.LbAlgorithm lbAlgorithm, Integer tcpTimeout, Boolean tcpDraining, Integer tcpDrainingTimeout, Integer udpTimeout, Listener.SSLProtocols sslProtocols, Listener.SSLCiphers sslCiphers, String certificateId, List<String> certificates) {
        this.name = name;
        this.description = description;
        this.port = port;
        this.backendPort = backendPort;
        this.lbAlgorithm = lbAlgorithm;
        this.tcpTimeout = tcpTimeout;
        this.tcpDraining = tcpDraining;
        this.tcpDrainingTimeout = tcpDrainingTimeout;
        this.udpTimeout = udpTimeout;
        this.sslProtocols = sslProtocols;
        this.sslCiphers = sslCiphers;
        this.certificateId = certificateId;
        this.certificates = certificates;
    }

    public static class ELBListenerUpdateBuilder {
        private String name;
        private String description;
        private Integer port;
        private Integer backendPort;
        private Listener.LbAlgorithm lbAlgorithm;
        private Integer tcpTimeout;
        private Boolean tcpDraining;
        private Integer tcpDrainingTimeout;
        private Integer udpTimeout;
        private Listener.SSLProtocols sslProtocols;
        private Listener.SSLCiphers sslCiphers;
        private String certificateId;
        private List<String> certificates;

        ELBListenerUpdateBuilder() {
        }

        public ELBListenerUpdateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ELBListenerUpdateBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ELBListenerUpdateBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public ELBListenerUpdateBuilder backendPort(Integer backendPort) {
            this.backendPort = backendPort;
            return this;
        }

        public ELBListenerUpdateBuilder lbAlgorithm(Listener.LbAlgorithm lbAlgorithm) {
            this.lbAlgorithm = lbAlgorithm;
            return this;
        }

        public ELBListenerUpdateBuilder tcpTimeout(Integer tcpTimeout) {
            this.tcpTimeout = tcpTimeout;
            return this;
        }

        public ELBListenerUpdateBuilder tcpDraining(Boolean tcpDraining) {
            this.tcpDraining = tcpDraining;
            return this;
        }

        public ELBListenerUpdateBuilder tcpDrainingTimeout(Integer tcpDrainingTimeout) {
            this.tcpDrainingTimeout = tcpDrainingTimeout;
            return this;
        }

        public ELBListenerUpdateBuilder udpTimeout(Integer udpTimeout) {
            this.udpTimeout = udpTimeout;
            return this;
        }

        public ELBListenerUpdateBuilder sslProtocols(Listener.SSLProtocols sslProtocols) {
            this.sslProtocols = sslProtocols;
            return this;
        }

        public ELBListenerUpdateBuilder sslCiphers(Listener.SSLCiphers sslCiphers) {
            this.sslCiphers = sslCiphers;
            return this;
        }

        public ELBListenerUpdateBuilder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public ELBListenerUpdateBuilder certificates(List<String> certificates) {
            this.certificates = certificates;
            return this;
        }

        public ELBListenerUpdate build() {
            return new ELBListenerUpdate(this.name, this.description, this.port, this.backendPort, this.lbAlgorithm, this.tcpTimeout, this.tcpDraining, this.tcpDrainingTimeout, this.udpTimeout, this.sslProtocols, this.sslCiphers, this.certificateId, this.certificates);
        }

        public String toString() {
            return "ELBListenerUpdate.ELBListenerUpdateBuilder(name=" + this.name + ", description=" + this.description + ", port=" + this.port + ", backendPort=" + this.backendPort + ", lbAlgorithm=" + (Object)((Object)this.lbAlgorithm) + ", tcpTimeout=" + this.tcpTimeout + ", tcpDraining=" + this.tcpDraining + ", tcpDrainingTimeout=" + this.tcpDrainingTimeout + ", udpTimeout=" + this.udpTimeout + ", sslProtocols=" + (Object)((Object)this.sslProtocols) + ", sslCiphers=" + (Object)((Object)this.sslCiphers) + ", certificateId=" + this.certificateId + ", certificates=" + this.certificates + ")";
        }
    }
}

