/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.domain;

import com.huawei.openstack4j.model.ModelEntity;
import java.beans.ConstructorProperties;

public class Resource
implements ModelEntity {
    private static final long serialVersionUID = 3901319971298532138L;
    private String tpye;
    private Integer used;
    private Integer quota;
    private Integer max;
    private Integer min;

    public static ResourceBuilder builder() {
        return new ResourceBuilder();
    }

    public ResourceBuilder toBuilder() {
        return new ResourceBuilder().tpye(this.tpye).used(this.used).quota(this.quota).max(this.max).min(this.min);
    }

    public String getTpye() {
        return this.tpye;
    }

    public Integer getUsed() {
        return this.used;
    }

    public Integer getQuota() {
        return this.quota;
    }

    public Integer getMax() {
        return this.max;
    }

    public Integer getMin() {
        return this.min;
    }

    public String toString() {
        return "Resource(tpye=" + this.getTpye() + ", used=" + this.getUsed() + ", quota=" + this.getQuota() + ", max=" + this.getMax() + ", min=" + this.getMin() + ")";
    }

    public Resource() {
    }

    @ConstructorProperties(value={"tpye", "used", "quota", "max", "min"})
    public Resource(String tpye, Integer used, Integer quota, Integer max, Integer min) {
        this.tpye = tpye;
        this.used = used;
        this.quota = quota;
        this.max = max;
        this.min = min;
    }

    public static class ResourceBuilder {
        private String tpye;
        private Integer used;
        private Integer quota;
        private Integer max;
        private Integer min;

        ResourceBuilder() {
        }

        public ResourceBuilder tpye(String tpye) {
            this.tpye = tpye;
            return this;
        }

        public ResourceBuilder used(Integer used) {
            this.used = used;
            return this;
        }

        public ResourceBuilder quota(Integer quota) {
            this.quota = quota;
            return this;
        }

        public ResourceBuilder max(Integer max) {
            this.max = max;
            return this;
        }

        public ResourceBuilder min(Integer min) {
            this.min = min;
            return this;
        }

        public Resource build() {
            return new Resource(this.tpye, this.used, this.quota, this.max, this.min);
        }

        public String toString() {
            return "Resource.ResourceBuilder(tpye=" + this.tpye + ", used=" + this.used + ", quota=" + this.quota + ", max=" + this.max + ", min=" + this.min + ")";
        }
    }
}

