/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.loadbalance.ELBCertificateService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.loadbalance.Certificate;
import com.huawei.openstack4j.model.loadbalance.CertificateUpdate;
import com.huawei.openstack4j.openstack.loadbalance.domain.ELBCertificate;
import com.huawei.openstack4j.openstack.loadbalance.internal.BaseELBServices;

public class ELBCertificateSeviceImpl
extends BaseELBServices
implements ELBCertificateService {
    private static final String API_PATH = "/elbaas/certificate";

    @Override
    public Certificate create(Certificate cert) {
        Preconditions.checkArgument((cert != null ? 1 : 0) != 0, (Object)"cert is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cert.getCertificate()) ? 1 : 0) != 0, (Object)"certificate is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cert.getPrivateKey()) ? 1 : 0) != 0, (Object)"privateKey is required");
        return this.post(ELBCertificate.class, this.uri(API_PATH, new Object[0])).entity(cert).execute();
    }

    @Override
    public ActionResponse delete(String certificateId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)certificateId) ? 1 : 0) != 0, (Object)"certificateId is required");
        return this.deleteWithResponse(this.uri("%s/%s", API_PATH, certificateId)).execute();
    }

    @Override
    public Certificate update(String certificateId, CertificateUpdate cert) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)certificateId) ? 1 : 0) != 0, (Object)"certificateId is required");
        Preconditions.checkArgument((cert != null ? 1 : 0) != 0, (Object)"cert is required");
        return this.put(ELBCertificate.class, this.uri("%s/%s", API_PATH, certificateId)).entity(cert).execute();
    }

    @Override
    public ELBCertificate.Certificates list() {
        return this.get(ELBCertificate.Certificates.class, this.uri(API_PATH, new Object[0])).execute();
    }
}

