/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.loadbalance.ELBHealthCheckService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.loadbalance.HealthCheck;
import com.huawei.openstack4j.model.loadbalance.HealthCheckCreate;
import com.huawei.openstack4j.model.loadbalance.HealthCheckUpdate;
import com.huawei.openstack4j.openstack.loadbalance.domain.ELBHealthCheck;
import com.huawei.openstack4j.openstack.loadbalance.internal.BaseELBServices;

public class ELBHealthCheckServiceImpl
extends BaseELBServices
implements ELBHealthCheckService {
    private static final String API_PATH = "/elbaas/healthcheck";

    @Override
    public HealthCheck create(HealthCheckCreate healthCheck) {
        Preconditions.checkArgument((healthCheck != null ? 1 : 0) != 0, (Object)"healthCheck is reuquired");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)healthCheck.getListenerId()) ? 1 : 0) != 0, (Object)"listenerId is required");
        return this.post(ELBHealthCheck.class, this.uri(API_PATH, new Object[0])).entity(healthCheck).execute();
    }

    @Override
    public ActionResponse delete(String healthCheckId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)healthCheckId) ? 1 : 0) != 0, (Object)"healthCheckId is required");
        return this.deleteWithResponse(this.uri("%s/%s", API_PATH, healthCheckId)).execute();
    }

    @Override
    public HealthCheck update(String healthCheckId, HealthCheckUpdate healthCheck) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)healthCheckId) ? 1 : 0) != 0, (Object)"healthCheckId is required");
        Preconditions.checkArgument((healthCheck != null ? 1 : 0) != 0, (Object)"healthCheck is reuquired");
        return this.put(ELBHealthCheck.class, this.uri("%s/%s", API_PATH, healthCheckId)).entity(healthCheck).execute();
    }

    @Override
    public HealthCheck get(String healthCheckId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)healthCheckId) ? 1 : 0) != 0, (Object)"healthCheckId is required");
        return this.get(ELBHealthCheck.class, this.uri("%s/%s", API_PATH, healthCheckId)).execute();
    }
}

