/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.loadbalance.ELBListenerService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.loadbalance.Listener;
import com.huawei.openstack4j.model.loadbalance.ListenerCreate;
import com.huawei.openstack4j.model.loadbalance.ListenerUpdate;
import com.huawei.openstack4j.openstack.loadbalance.domain.ELBListener;
import com.huawei.openstack4j.openstack.loadbalance.internal.BaseELBServices;
import com.huawei.openstack4j.openstack.loadbalance.options.ELBListenerListOptions;

public class ELBListenerServiceImpl
extends BaseELBServices
implements ELBListenerService {
    private static final String API_PATH = "/elbaas/listeners";

    @Override
    public Listener create(ListenerCreate listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"listener is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listener.getName()) ? 1 : 0) != 0, (Object)"name is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listener.getLoadBalancerId()) ? 1 : 0) != 0, (Object)"loadBalancerId is required");
        Preconditions.checkArgument((listener.getProtocol() != null ? 1 : 0) != 0, (Object)"protocol is required");
        Preconditions.checkArgument((listener.getPort() != null ? 1 : 0) != 0, (Object)"port is required");
        Preconditions.checkArgument((listener.getBackendProtocol() != null ? 1 : 0) != 0, (Object)"backendProtocol is required");
        Preconditions.checkArgument((listener.getBackendPort() != null ? 1 : 0) != 0, (Object)"backendPort is required");
        Preconditions.checkArgument((listener.getLbAlgorithm() != null ? 1 : 0) != 0, (Object)"lbAlgorithm is required");
        return this.post(ELBListener.class, this.uri(API_PATH, new Object[0])).entity(listener).execute();
    }

    @Override
    public ActionResponse delete(String listenerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listenerId) ? 1 : 0) != 0, (Object)"listenerId is required");
        return this.deleteWithResponse(this.uri("%s/%s", API_PATH, listenerId)).execute();
    }

    @Override
    public Listener update(String listenerId, ListenerUpdate listener) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listenerId) ? 1 : 0) != 0, (Object)"listenerId is required");
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"listener is required");
        return this.put(ELBListener.class, this.uri("%s/%s", API_PATH, listenerId)).entity(listener).execute();
    }

    @Override
    public Listener get(String listenerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listenerId) ? 1 : 0) != 0, (Object)"listenerId is required");
        return this.get(ELBListener.class, this.uri("%s/%s", API_PATH, listenerId)).execute();
    }

    @Override
    public Listener[] list() {
        return this.get(ELBListener[].class, this.uri(API_PATH, new Object[0])).execute();
    }

    @Override
    public Listener[] list(ELBListenerListOptions options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options is required");
        return this.get(ELBListener[].class, this.uri(API_PATH, new Object[0])).params(options.getOptions()).execute();
    }
}

