/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.loadbalance.ELBLoadBalancerService;
import com.huawei.openstack4j.model.loadbalance.LoadBalancer;
import com.huawei.openstack4j.model.loadbalance.LoadBalancerCreate;
import com.huawei.openstack4j.model.loadbalance.LoadBalancerUpdate;
import com.huawei.openstack4j.openstack.loadbalance.domain.ELBJob;
import com.huawei.openstack4j.openstack.loadbalance.domain.ELBLoadBalancer;
import com.huawei.openstack4j.openstack.loadbalance.internal.BaseELBServices;
import com.huawei.openstack4j.openstack.loadbalance.options.ELBLoadBalancerListOptions;
import java.util.List;

public class ELBLoadBalancerServiceImpl
extends BaseELBServices
implements ELBLoadBalancerService {
    private static final String API_PATH = "/elbaas/loadbalancers";

    @Override
    public ELBJob create(LoadBalancerCreate loadBalancer) {
        Preconditions.checkArgument((loadBalancer != null ? 1 : 0) != 0, (Object)"loadBalancer is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)loadBalancer.getName()) ? 1 : 0) != 0, (Object)"name is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)loadBalancer.getVpcId()) ? 1 : 0) != 0, (Object)"vpcId is required");
        Preconditions.checkArgument((loadBalancer.getType() != null ? 1 : 0) != 0, (Object)"type is required");
        Preconditions.checkArgument((loadBalancer.getAdminStateUp() != null ? 1 : 0) != 0, (Object)"adminStateUp is required");
        if (LoadBalancer.Type.INTERNAL.name().equals((Object)loadBalancer.getType())) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)loadBalancer.getVipSubnetId()) ? 1 : 0) != 0, (Object)"vipSubnetId is required when type is Internal");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)loadBalancer.getAzId()) ? 1 : 0) != 0, (Object)"azId is required when type is Internal");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)loadBalancer.getTenantId()) ? 1 : 0) != 0, (Object)"tenantId is required when type is Internal");
        }
        if (LoadBalancer.Type.EXTERNAL.name().equals((Object)loadBalancer.getType())) {
            Preconditions.checkArgument((loadBalancer.getBandwidth() != null ? 1 : 0) != 0, (Object)"bandwidth is required when type is External");
        }
        return this.post(ELBJob.class, this.uri(API_PATH, new Object[0])).entity(loadBalancer).execute();
    }

    @Override
    public ELBJob delete(String loadBalancerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)loadBalancerId) ? 1 : 0) != 0, (Object)"loadBalancerId is required");
        return this.delete(ELBJob.class, this.uri("%s/%s", API_PATH, loadBalancerId)).execute();
    }

    @Override
    public ELBJob update(String loadBalancerId, LoadBalancerUpdate loadBalancer) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)loadBalancerId) ? 1 : 0) != 0, (Object)"loadBalancerId is required");
        Preconditions.checkArgument((loadBalancer != null ? 1 : 0) != 0, (Object)"loadBalancer is required");
        return this.put(ELBJob.class, this.uri("%s/%s", API_PATH, loadBalancerId)).entity(loadBalancer).execute();
    }

    @Override
    public LoadBalancer get(String loadBalancerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)loadBalancerId) ? 1 : 0) != 0, (Object)"loadBalancerId is required");
        return this.get(ELBLoadBalancer.class, this.uri("%s/%s", API_PATH, loadBalancerId)).execute();
    }

    @Override
    public List<? extends LoadBalancer> list() {
        return this.get(ELBLoadBalancer.ELBLoadBalancers.class, this.uri(API_PATH, new Object[0])).execute().getList();
    }

    @Override
    public List<? extends LoadBalancer> list(ELBLoadBalancerListOptions options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options is required");
        return this.get(ELBLoadBalancer.ELBLoadBalancers.class, this.uri(API_PATH, new Object[0])).params(options.getOptions()).execute().getList();
    }
}

