/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.api.loadbalance.ELBServerService;
import com.huawei.openstack4j.model.loadbalance.Server;
import com.huawei.openstack4j.model.loadbalance.ServerCreate;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import com.huawei.openstack4j.openstack.loadbalance.domain.ELBJob;
import com.huawei.openstack4j.openstack.loadbalance.domain.ELBServer;
import com.huawei.openstack4j.openstack.loadbalance.domain.ELBServerDelete;
import com.huawei.openstack4j.openstack.loadbalance.internal.BaseELBServices;
import com.huawei.openstack4j.openstack.loadbalance.options.ELBServerListOptions;
import java.util.ArrayList;
import java.util.List;

public class ELBServerServiceImpl
extends BaseELBServices
implements ELBServerService {
    private static final String API_PATH = "/elbaas/listeners";

    @Override
    public ELBJob create(String listenerId, List<ServerCreate> servers) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listenerId) ? 1 : 0) != 0, (Object)"listenerId is required");
        Preconditions.checkArgument((servers != null && !servers.isEmpty() ? 1 : 0) != 0, (Object)"servers is required");
        for (ServerCreate server : servers) {
            Preconditions.checkArgument((server != null ? 1 : 0) != 0, (Object)"server can not be null");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)server.getServerId()) ? 1 : 0) != 0, (Object)"serverId is required");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)server.getAddress()) ? 1 : 0) != 0, (Object)"server address is required");
        }
        return this.post(ELBJob.class, this.uri("%s/%s/members", API_PATH, listenerId)).entity(servers).execute();
    }

    @Override
    public ELBJob delete(String listenerId, List<String> servers) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listenerId) ? 1 : 0) != 0, (Object)"listenerId is required");
        Preconditions.checkArgument((servers != null && servers.size() > 0 ? 1 : 0) != 0, (Object)"servers is required");
        ArrayList toRemove = Lists.newArrayList();
        for (String server : servers) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)server) ? 1 : 0) != 0, (Object)"invalid server id in `servers` parameter");
            toRemove.add(new IdResourceEntity(server));
        }
        ELBServerDelete delete = ELBServerDelete.builder().removeMember(toRemove).build();
        return this.post(ELBJob.class, this.uri("%s/%s/members/action", API_PATH, listenerId)).entity(delete).execute();
    }

    @Override
    public Server[] list(String listenerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listenerId) ? 1 : 0) != 0, (Object)"listenerId is required");
        return this.get(ELBServer[].class, this.uri("%s/%s/members", API_PATH, listenerId)).execute();
    }

    @Override
    public Server[] list(String listenerId, ELBServerListOptions options) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listenerId) ? 1 : 0) != 0, (Object)"listenerId is required");
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options is required");
        return this.get(ELBServer[].class, this.uri("%s/%s/members", API_PATH, listenerId)).params(options.getOptions()).execute();
    }
}

