/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public class ELBServerListOptions {
    private Map<String, Object> queryParam = Maps.newHashMap();

    private ELBServerListOptions() {
    }

    public static ELBServerListOptions create() {
        return new ELBServerListOptions();
    }

    public ELBServerListOptions marker(String marker) {
        return this.add("marker", marker);
    }

    public ELBServerListOptions limit(int limit) {
        return this.add("limit", String.valueOf(limit));
    }

    public ELBServerListOptions serverAddress(String serverAddress) {
        return this.add("server_address", serverAddress);
    }

    public ELBServerListOptions id(String id) {
        return this.add("id", id);
    }

    public ELBServerListOptions address(String address) {
        return this.add("address", address);
    }

    public ELBServerListOptions status(Status status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"status is required");
        return this.add("status", status.name());
    }

    public ELBServerListOptions healthStatus(HealthStatus healthStatus) {
        Preconditions.checkArgument((healthStatus != null ? 1 : 0) != 0, (Object)"healthStatus is required");
        return this.add("health_status", healthStatus.name());
    }

    public ELBServerListOptions serverId(String serverId) {
        return this.add("server_id", serverId);
    }

    private ELBServerListOptions add(String key, Object value) {
        if (value != null) {
            this.queryParam.put(key, value);
        }
        return this;
    }

    public Map<String, Object> getOptions() {
        return this.queryParam;
    }

    public static enum HealthStatus {
        NORMAL,
        ABNORMAL,
        UNAVAILABLE;

    }

    public static enum Status {
        ACTIVE,
        PENDING,
        ERROR;

    }
}

