/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.maas.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.maas.constants.Operation;
import com.huawei.openstack4j.openstack.maas.constants.State;
import com.huawei.openstack4j.openstack.maas.domain.Task;
import com.huawei.openstack4j.openstack.maas.domain.TaskCreate;
import com.huawei.openstack4j.openstack.maas.domain.TaskCreateResp;
import com.huawei.openstack4j.openstack.maas.domain.TaskStart;
import com.huawei.openstack4j.openstack.maas.internal.BaseMaaSService;
import com.huawei.openstack4j.openstack.maas.options.TaskListOptions;
import java.util.HashMap;
import java.util.Map;

public class TaskService
extends BaseMaaSService
implements RestService {
    public TaskCreateResp create(TaskCreate task) {
        Preconditions.checkArgument((task != null ? 1 : 0) != 0, (Object)"task is required");
        Preconditions.checkArgument((task.getEnableKMS() != null ? 1 : 0) != 0, (Object)"enableKMS is required");
        Preconditions.checkArgument((task.getThreadNum() != null ? 1 : 0) != 0, (Object)"threadNum is required");
        this.checkNode(task.getSrcNode(), "srcNode");
        this.checkNode(task.getDstNode(), "dstNode");
        this.checkSmnInfoWhenPresent(task.getSmnInfo());
        return this.post(TaskCreateResp.class, this.uri("/task", new Object[0])).entity(task).execute();
    }

    public ActionResponse delete(long taskId) {
        return this.deleteWithResponse(this.uri("/task/%s", taskId)).execute();
    }

    public ActionResponse start(long taskId, TaskStart task) {
        Preconditions.checkArgument((task != null ? 1 : 0) != 0, (Object)"task is required");
        Preconditions.checkArgument((task.getOperation() != null ? 1 : 0) != 0, (Object)"task.operation is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)task.getSourceAk()) ? 1 : 0) != 0, (Object)"task.sourceAk is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)task.getSourceSk()) ? 1 : 0) != 0, (Object)"task.sourceSk is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)task.getTargetAk()) ? 1 : 0) != 0, (Object)"task.targetAk is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)task.getTargetSk()) ? 1 : 0) != 0, (Object)"task.targetSk is required");
        return this.putWithResponse(this.uri("/task/%s", taskId)).entity(task).execute();
    }

    public ActionResponse stop(long taskId) {
        HashMap entity = Maps.newHashMap();
        entity.put("operation", Operation.STOP.name().toLowerCase());
        return this.putWithResponse(this.uri("/task/%s", taskId)).entity(entity).execute();
    }

    public Task[] list(TaskListOptions options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options is required");
        Preconditions.checkArgument((boolean)options.getOptions().containsKey("start"), (Object)"options.start is required");
        Preconditions.checkArgument((boolean)options.getOptions().containsKey("limit"), (Object)"options.limit is required");
        return this.get(Task[].class, this.uri("/task", new Object[0])).params(options.getOptions()).execute();
    }

    public long count() {
        Map result = this.get(Map.class, this.uri("/task", new Object[0])).param("totalcount", true).execute();
        if (result.containsKey("taskcount")) {
            Integer taskcount = (Integer)result.get("taskcount");
            return taskcount.longValue();
        }
        return 0L;
    }

    public long count(State state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state is required");
        Map result = this.get(Map.class, this.uri("/task", new Object[0])).param("totalcount", true).param("state", state.getVal()).execute();
        if (result.containsKey("taskcount")) {
            Integer taskcount = (Integer)result.get("taskcount");
            return taskcount.longValue();
        }
        return 0L;
    }

    public Task get(long taskId) {
        return this.get(Task.class, this.uri("/task/%s", taskId)).execute();
    }

    private void checkSmnInfoWhenPresent(TaskCreate.SmnInfo smnInfo) {
        if (smnInfo != null) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)smnInfo.getTopicUrn()) ? 1 : 0) != 0, (Object)"smnInfo.topicUrn is required");
            Preconditions.checkArgument((smnInfo.getTriggerConditions() != null ? 1 : 0) != 0, (Object)"smnInfo.triggerConditions is required");
        }
    }

    private void checkNode(TaskCreate.Node node, String fieldName) {
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)String.format("%s is required", fieldName));
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)String.format("%s is required", fieldName));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)node.getRegion()) ? 1 : 0) != 0, (Object)String.format("%s.region is required", fieldName));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)node.getAk()) ? 1 : 0) != 0, (Object)String.format("%s.ak is required", fieldName));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)node.getSk()) ? 1 : 0) != 0, (Object)String.format("%s.sk is required", fieldName));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)node.getBucket()) ? 1 : 0) != 0, (Object)String.format("%s.bucket is required", fieldName));
        Preconditions.checkArgument((node.getObjectKey() != null ? 1 : 0) != 0, (Object)String.format("%s.objectKey is required", fieldName));
        if (node.getObjectKey() instanceof Map) {
            Map map = (Map)node.getObjectKey();
            Preconditions.checkArgument((boolean)map.containsKey("path"), (Object)String.format("%s.objectKey.path is required", fieldName));
            Preconditions.checkArgument((boolean)map.containsKey("keys"), (Object)String.format("%s.objectKey.Keys is required", fieldName));
        }
    }
}

