/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.manila.domain.actions;

import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.manila.Share;
import com.huawei.openstack4j.model.manila.actions.AccessOptions;
import com.huawei.openstack4j.openstack.manila.domain.actions.GrantAccessAction;
import com.huawei.openstack4j.openstack.manila.domain.actions.ResetStateAction;
import com.huawei.openstack4j.openstack.manila.domain.actions.RevokeAccessAction;
import com.huawei.openstack4j.openstack.manila.domain.actions.ShareAction;
import com.huawei.openstack4j.openstack.manila.domain.actions.SizeAction;

public final class ShareActions {
    public static GrantAccessAction grantAccess(AccessOptions options) {
        return new GrantAccessAction(options.getAccessLevel(), options.getAccessType(), options.getAccessTo());
    }

    public static RevokeAccessAction revokeAccess(String accessId) {
        return new RevokeAccessAction(accessId);
    }

    public static ListAccessRulesAction listAccessRules() {
        return new ListAccessRulesAction();
    }

    public static ResetStateAction resetState(Share.Status status) {
        return new ResetStateAction(status);
    }

    public static ForceDeleteAction forceDelete() {
        return new ForceDeleteAction();
    }

    public static SizeAction.Extend extend(int newSize) {
        return new SizeAction.Extend(newSize);
    }

    public static SizeAction.Shrink shrink(int newSize) {
        return new SizeAction.Shrink(newSize);
    }

    @JsonRootName(value="os-force_delete")
    public static class ForceDeleteAction
    implements ShareAction {
    }

    @JsonRootName(value="os-access_list")
    public static class ListAccessRulesAction
    implements ShareAction {
    }
}

