/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.manila.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.manila.SecurityServiceService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.manila.SecurityService;
import com.huawei.openstack4j.model.manila.SecurityServiceCreate;
import com.huawei.openstack4j.model.manila.SecurityServiceUpdateOptions;
import com.huawei.openstack4j.model.manila.builder.SecurityServiceCreateBuilder;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.manila.domain.ManilaSecurityService;
import com.huawei.openstack4j.openstack.manila.domain.ManilaSecurityServiceCreate;
import com.huawei.openstack4j.openstack.manila.domain.ManilaSecurityServiceUpdate;
import com.huawei.openstack4j.openstack.manila.internal.BaseShareServices;
import java.util.List;

public class SecurityServiceServiceImpl
extends BaseShareServices
implements SecurityServiceService {
    @Override
    public SecurityService create(SecurityServiceCreate securityServiceCreate) {
        Preconditions.checkNotNull((Object)securityServiceCreate);
        return this.post(ManilaSecurityService.class, this.uri("/security-services", new Object[0])).entity(securityServiceCreate).execute();
    }

    @Override
    public List<? extends SecurityService> list() {
        return this.list(false);
    }

    @Override
    public List<? extends SecurityService> listDetails() {
        return this.list(true);
    }

    private List<? extends SecurityService> list(boolean detail) {
        return this.get(ManilaSecurityService.SecurityServices.class, this.uri("/security-services" + (detail ? "/detail" : ""), new Object[0])).execute().getList();
    }

    @Override
    public SecurityService get(String securityServiceId) {
        Preconditions.checkNotNull((Object)securityServiceId);
        return this.get(ManilaSecurityService.class, this.uri("/security-services/%s", securityServiceId)).execute();
    }

    @Override
    public SecurityService update(String securityServiceId, SecurityServiceUpdateOptions securityServiceUpdateOptions) {
        Preconditions.checkNotNull((Object)securityServiceId);
        Preconditions.checkNotNull((Object)securityServiceUpdateOptions);
        return this.put(ManilaSecurityService.class, this.uri("/security-services/%s", securityServiceId)).entity(ManilaSecurityServiceUpdate.fromOptions(securityServiceUpdateOptions)).execute();
    }

    @Override
    public ActionResponse delete(String securityServiceId) {
        Preconditions.checkNotNull((Object)securityServiceId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/security-services/%s", securityServiceId)).executeWithResponse());
    }

    @Override
    public SecurityServiceCreateBuilder securityServiceCreateBuilder() {
        return ManilaSecurityServiceCreate.builder();
    }
}

