/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.manila.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.manila.ShareInstanceService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.manila.ShareInstance;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.manila.domain.ManilaShareInstance;
import com.huawei.openstack4j.openstack.manila.domain.actions.ShareInstanceActions;
import com.huawei.openstack4j.openstack.manila.internal.BaseShareServices;
import java.util.List;

public class ShareInstanceServiceImpl
extends BaseShareServices
implements ShareInstanceService {
    @Override
    public List<? extends ShareInstance> list() {
        return this.get(ManilaShareInstance.ShareInstances.class, this.uri("/share_instances", new Object[0])).execute().getList();
    }

    @Override
    public ShareInstance get(String shareInstanceId) {
        Preconditions.checkNotNull((Object)shareInstanceId);
        return this.get(ManilaShareInstance.class, this.uri("/share_instances/%s", shareInstanceId)).execute();
    }

    @Override
    public ActionResponse resetState(String shareInstanceId, ShareInstance.Status status) {
        Preconditions.checkNotNull((Object)shareInstanceId);
        Preconditions.checkNotNull((Object)((Object)status));
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/share_instances/%s/action", shareInstanceId)).entity(ShareInstanceActions.resetState(status)).executeWithResponse());
    }

    @Override
    public ActionResponse forceDelete(String shareInstanceId) {
        Preconditions.checkNotNull((Object)shareInstanceId);
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/share_instances/%s/action", shareInstanceId)).entity(ShareInstanceActions.forceDelete()).executeWithResponse());
    }
}

