/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.manila.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.manila.ShareNetworkService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.manila.ShareNetwork;
import com.huawei.openstack4j.model.manila.ShareNetworkCreate;
import com.huawei.openstack4j.model.manila.ShareNetworkUpdateOptions;
import com.huawei.openstack4j.model.manila.builder.ShareNetworkCreateBuilder;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.manila.domain.ManilaShareNetwork;
import com.huawei.openstack4j.openstack.manila.domain.ManilaShareNetworkCreate;
import com.huawei.openstack4j.openstack.manila.domain.ManilaShareNetworkUpdate;
import com.huawei.openstack4j.openstack.manila.domain.actions.SecurityServiceAction;
import com.huawei.openstack4j.openstack.manila.internal.BaseShareServices;
import java.util.List;

public class ShareNetworkServiceImpl
extends BaseShareServices
implements ShareNetworkService {
    @Override
    public ShareNetwork create(ShareNetworkCreate shareNetworkCreate) {
        Preconditions.checkNotNull((Object)shareNetworkCreate);
        return this.post(ManilaShareNetwork.class, this.uri("/share-networks", new Object[0])).entity(shareNetworkCreate).execute();
    }

    @Override
    public List<? extends ShareNetwork> list() {
        return this.list(false);
    }

    @Override
    public List<? extends ShareNetwork> listDetails() {
        return this.list(true);
    }

    private List<? extends ShareNetwork> list(boolean detail) {
        return this.get(ManilaShareNetwork.ShareNetworks.class, this.uri("/share-networks" + (detail ? "/detail" : ""), new Object[0])).execute().getList();
    }

    @Override
    public ShareNetwork get(String shareNetworkId) {
        Preconditions.checkNotNull((Object)shareNetworkId);
        return this.get(ManilaShareNetwork.class, this.uri("/share-networks/%s", shareNetworkId)).execute();
    }

    @Override
    public ShareNetwork update(String shareNetworkId, ShareNetworkUpdateOptions shareNetworkUpdateOptions) {
        Preconditions.checkNotNull((Object)shareNetworkId);
        Preconditions.checkNotNull((Object)shareNetworkUpdateOptions);
        return this.put(ManilaShareNetwork.class, this.uri("/share-networks/%s", shareNetworkId)).entity(ManilaShareNetworkUpdate.fromOptions(shareNetworkUpdateOptions)).execute();
    }

    @Override
    public ActionResponse delete(String shareNetworkId) {
        Preconditions.checkNotNull((Object)shareNetworkId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/share-networks/%s", shareNetworkId)).executeWithResponse());
    }

    @Override
    public ShareNetwork addSecurityService(String shareNetworkId, String securityServiceId) {
        Preconditions.checkNotNull((Object)shareNetworkId);
        Preconditions.checkNotNull((Object)securityServiceId);
        return this.invokeSecurityServiceAction(shareNetworkId, SecurityServiceAction.add(securityServiceId));
    }

    @Override
    public ShareNetwork removeSecurityService(String shareNetworkId, String securityServiceId) {
        Preconditions.checkNotNull((Object)shareNetworkId);
        Preconditions.checkNotNull((Object)securityServiceId);
        return this.invokeSecurityServiceAction(shareNetworkId, SecurityServiceAction.remove(securityServiceId));
    }

    private ShareNetwork invokeSecurityServiceAction(String shareNetworkId, SecurityServiceAction action) {
        return this.post(ManilaShareNetwork.class, this.uri("/share-networks/%s/action", shareNetworkId)).entity(action).execute();
    }

    @Override
    public ShareNetworkCreateBuilder shareNetworkCreateBuilder() {
        return ManilaShareNetworkCreate.builder();
    }
}

