/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.manila.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.Apis;
import com.huawei.openstack4j.api.manila.QuotaSetService;
import com.huawei.openstack4j.api.manila.SchedulerStatsService;
import com.huawei.openstack4j.api.manila.SecurityServiceService;
import com.huawei.openstack4j.api.manila.ShareInstanceService;
import com.huawei.openstack4j.api.manila.ShareNetworkService;
import com.huawei.openstack4j.api.manila.ShareServerService;
import com.huawei.openstack4j.api.manila.ShareService;
import com.huawei.openstack4j.api.manila.ShareSnapshotService;
import com.huawei.openstack4j.api.manila.ShareTypeService;
import com.huawei.openstack4j.api.manila.SharesService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.common.Extension;
import com.huawei.openstack4j.model.manila.AvailabilityZone;
import com.huawei.openstack4j.model.manila.Limits;
import com.huawei.openstack4j.model.manila.Service;
import com.huawei.openstack4j.model.manila.Share;
import com.huawei.openstack4j.model.manila.ShareManage;
import com.huawei.openstack4j.openstack.common.ExtensionValue;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.manila.domain.ManilaAvailabilityZone;
import com.huawei.openstack4j.openstack.manila.domain.ManilaLimits;
import com.huawei.openstack4j.openstack.manila.domain.ManilaService;
import com.huawei.openstack4j.openstack.manila.domain.ManilaShare;
import com.huawei.openstack4j.openstack.manila.domain.actions.ServiceAction;
import com.huawei.openstack4j.openstack.manila.internal.BaseShareServices;
import java.util.List;

public class ShareServiceImpl
extends BaseShareServices
implements ShareService {
    @Override
    public List<? extends Extension> listExtensions() {
        return this.get(ExtensionValue.Extensions.class, this.uri("/extensions", new Object[0])).execute().getList();
    }

    @Override
    public Limits limits() {
        return this.get(ManilaLimits.class, this.uri("/limits", new Object[0])).execute();
    }

    @Override
    public SharesService shares() {
        return Apis.get(SharesService.class);
    }

    @Override
    public SecurityServiceService securityServices() {
        return Apis.get(SecurityServiceService.class);
    }

    @Override
    public ShareSnapshotService shareSnapshots() {
        return Apis.get(ShareSnapshotService.class);
    }

    @Override
    public ShareNetworkService shareNetworks() {
        return Apis.get(ShareNetworkService.class);
    }

    @Override
    public ShareServerService shareServers() {
        return Apis.get(ShareServerService.class);
    }

    @Override
    public ShareInstanceService shareInstances() {
        return Apis.get(ShareInstanceService.class);
    }

    @Override
    public ShareTypeService shareTypes() {
        return Apis.get(ShareTypeService.class);
    }

    @Override
    public SchedulerStatsService schedulerStats() {
        return Apis.get(SchedulerStatsService.class);
    }

    @Override
    public List<? extends Service> services() {
        return this.get(ManilaService.Services.class, this.uri("/os-services", new Object[0])).execute().getList();
    }

    @Override
    public ManilaService.ServiceStatus enableService(String binary, String host) {
        Preconditions.checkNotNull((Object)binary);
        Preconditions.checkNotNull((Object)host);
        return this.put(ManilaService.ServiceStatus.class, this.uri("/os-services/enable", new Object[0])).entity(ServiceAction.enable(binary, host)).execute();
    }

    @Override
    public ManilaService.ServiceStatus disableService(String binary, String host) {
        Preconditions.checkNotNull((Object)binary);
        Preconditions.checkNotNull((Object)host);
        return this.put(ManilaService.ServiceStatus.class, this.uri("/os-services/disable", new Object[0])).entity(ServiceAction.disable(binary, host)).execute();
    }

    @Override
    public List<? extends AvailabilityZone> availabilityZones() {
        return this.get(ManilaAvailabilityZone.AvailabilityZones.class, this.uri("/os-availability-zone", new Object[0])).execute().getList();
    }

    @Override
    public Share manageShare(ShareManage shareManage) {
        Preconditions.checkNotNull((Object)shareManage);
        return this.post(ManilaShare.class, this.uri("/os-share-manage", new Object[0])).entity(shareManage).execute();
    }

    @Override
    public ActionResponse unmanageShare(String shareId) {
        Preconditions.checkNotNull((Object)shareId);
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/os-share-unmanage/%s/unmanage", shareId)).executeWithResponse());
    }

    @Override
    public QuotaSetService quotaSets() {
        return Apis.get(QuotaSetService.class);
    }
}

