/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.manila.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.manila.ShareSnapshotService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.manila.ShareSnapshot;
import com.huawei.openstack4j.model.manila.ShareSnapshotCreate;
import com.huawei.openstack4j.model.manila.ShareSnapshotUpdateOptions;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.manila.domain.ManilaShareSnapshot;
import com.huawei.openstack4j.openstack.manila.domain.ManilaShareSnapshotUpdate;
import com.huawei.openstack4j.openstack.manila.domain.actions.ShareSnapshotAction;
import com.huawei.openstack4j.openstack.manila.domain.actions.ShareSnapshotActions;
import com.huawei.openstack4j.openstack.manila.internal.BaseShareServices;
import java.util.List;

public class ShareSnapshotServiceImpl
extends BaseShareServices
implements ShareSnapshotService {
    @Override
    public ShareSnapshot create(ShareSnapshotCreate snapshotCreate) {
        Preconditions.checkNotNull((Object)snapshotCreate);
        return this.post(ManilaShareSnapshot.class, this.uri("/snapshots", new Object[0])).entity(snapshotCreate).execute();
    }

    @Override
    public List<? extends ShareSnapshot> list() {
        return this.list(false);
    }

    @Override
    public List<? extends ShareSnapshot> listDetails() {
        return this.list(true);
    }

    private List<? extends ShareSnapshot> list(boolean detail) {
        return this.get(ManilaShareSnapshot.ShareSnapshots.class, this.uri("/snapshots" + (detail ? "/detail" : ""), new Object[0])).execute().getList();
    }

    @Override
    public ShareSnapshot get(String snapshotId) {
        Preconditions.checkNotNull((Object)snapshotId);
        return this.get(ManilaShareSnapshot.class, this.uri("/snapshots/%s", snapshotId)).execute();
    }

    @Override
    public ShareSnapshot update(String snapshotId, ShareSnapshotUpdateOptions snapshotUpdateOptions) {
        Preconditions.checkNotNull((Object)snapshotId);
        Preconditions.checkNotNull((Object)snapshotUpdateOptions);
        return this.put(ManilaShareSnapshot.class, this.uri("/snapshots/%s", snapshotId)).entity(ManilaShareSnapshotUpdate.fromOptions(snapshotUpdateOptions)).execute();
    }

    @Override
    public ActionResponse delete(String snapshotId) {
        Preconditions.checkNotNull((Object)snapshotId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/snapshots/%s", snapshotId)).executeWithResponse());
    }

    @Override
    public ActionResponse resetState(String snapshotId, ShareSnapshot.Status status) {
        Preconditions.checkNotNull((Object)snapshotId);
        Preconditions.checkNotNull((Object)((Object)status));
        return this.invokeAction(snapshotId, ShareSnapshotActions.resetState(status));
    }

    @Override
    public ActionResponse forceDelete(String snapshotId) {
        Preconditions.checkNotNull((Object)snapshotId);
        return this.invokeAction(snapshotId, ShareSnapshotActions.forceDelete());
    }

    private ActionResponse invokeAction(String snapshotId, ShareSnapshotAction action) {
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/snapshots/%s/action", snapshotId)).entity(action).executeWithResponse());
    }
}

