/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.model.compute.Image;
import com.huawei.openstack4j.model.map.reduce.Cluster;
import com.huawei.openstack4j.model.map.reduce.NodeGroup;
import com.huawei.openstack4j.model.map.reduce.ServiceConfig;
import com.huawei.openstack4j.model.map.reduce.ServiceInfo;
import com.huawei.openstack4j.model.map.reduce.builder.ClusterBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceNodeGroup;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceServiceConfig;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceServiceInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonRootName(value="cluster")
@JsonIgnoreProperties(ignoreUnknown=true)
public class MapReduceCluster
implements Cluster {
    private static final long serialVersionUID = 1L;
    private Cluster.Status status;
    @JsonProperty(value="info")
    private Map<String, MapReduceServiceInfo> infos;
    @JsonProperty(value="cluster_template_id")
    private String clusterTemplateId;
    @JsonProperty(value="is_transient")
    private Boolean isTransient;
    private String description;
    @JsonProperty(value="cluster_configs")
    private Map<String, MapReduceServiceConfig> clusterConfigs;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="default_image_id")
    private String defaultImageId;
    @JsonProperty(value="user_keypair_id")
    private String userKeypairId;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="plugin_name")
    private String pluginName;
    @JsonProperty(value="neutron_management_network")
    private String managementNetworkId;
    @JsonProperty(value="anti_affinity")
    private List<String> antiAffinity;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="node_groups")
    private List<MapReduceNodeGroup> nodeGroups;
    @JsonProperty(value="management_public_key")
    private String managementPublicKey;
    @JsonProperty(value="status_description")
    private String statusDescription;
    @JsonProperty(value="hadoop_version")
    private String hadoopVersion;
    private String id;
    @JsonProperty(value="trust_id")
    private String trustId;
    private String name;

    @Override
    public Cluster.Status getStatus() {
        return this.status;
    }

    @Override
    public Map<String, ? extends ServiceInfo> getInfos() {
        return this.infos;
    }

    @Override
    public String getClusterTemplateId() {
        return this.clusterTemplateId;
    }

    @Override
    public Boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, ? extends ServiceConfig> getClusterConfigs() {
        return this.clusterConfigs;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getDefaultImageId() {
        return this.defaultImageId;
    }

    @Override
    public String getUserKeypairId() {
        return this.userKeypairId;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public String getManagementNetworkId() {
        return this.managementNetworkId;
    }

    @Override
    public List<String> getAntiAffinity() {
        return this.antiAffinity;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public List<? extends NodeGroup> getNodeGroups() {
        return this.nodeGroups;
    }

    @Override
    public String getManagementPublicKey() {
        return this.managementPublicKey;
    }

    @Override
    public String getStatusDescription() {
        return this.statusDescription;
    }

    @Override
    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTrustId() {
        return this.trustId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("status", (Object)this.status).add("created_at", (Object)this.createdAt).add("updated_at", (Object)this.updatedAt).add("tenant_id", (Object)this.tenantId).add("cluster_template_id", (Object)this.clusterTemplateId).add("is_transient", (Object)this.isTransient).add("default_image_id", (Object)this.defaultImageId).add("user_keypair_id", (Object)this.userKeypairId).add("plugin_name", (Object)this.pluginName).add("neutron_management_network", (Object)this.managementNetworkId).add("cluster_configs", this.clusterConfigs).add("anti_affinity", this.antiAffinity).add("node_groups", this.nodeGroups).add("management_public_key", (Object)this.managementPublicKey).add("status_description", (Object)this.statusDescription).add("hadoop_version", (Object)this.hadoopVersion).add("trust_id", (Object)this.trustId).add("info", this.infos).toString();
    }

    @Override
    public ClusterBuilder toBuilder() {
        return new ConcreteClusterBuilder(this);
    }

    public static ClusterBuilder builder() {
        return new ConcreteClusterBuilder();
    }

    public static class ConcreteClusterBuilder
    implements ClusterBuilder {
        MapReduceCluster m;

        ConcreteClusterBuilder() {
            this(new MapReduceCluster());
        }

        ConcreteClusterBuilder(MapReduceCluster m) {
            this.m = m;
        }

        @Override
        public ClusterBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public ClusterBuilder hadoopVersion(String hadoopVersion) {
            this.m.hadoopVersion = hadoopVersion;
            return this;
        }

        @Override
        public ClusterBuilder pluginName(String pluginName) {
            this.m.pluginName = pluginName;
            return this;
        }

        @Override
        public ClusterBuilder template(String clusterTemplateId) {
            this.m.clusterTemplateId = clusterTemplateId;
            return this;
        }

        @Override
        public ClusterBuilder image(String imageId) {
            this.m.defaultImageId = imageId;
            return this;
        }

        public ClusterBuilder image(Image image) {
            this.m.defaultImageId = image.getId();
            return this;
        }

        @Override
        public ClusterBuilder keypairName(String keypairName) {
            this.m.userKeypairId = keypairName;
            return this;
        }

        @Override
        public ClusterBuilder managementNetworkId(String networkId) {
            this.m.managementNetworkId = networkId;
            return this;
        }

        @Override
        public ClusterBuilder addNodeGroup(NodeGroup nodeGroup) {
            if (this.m.nodeGroups == null) {
                this.m.nodeGroups = Lists.newArrayList();
            }
            this.m.nodeGroups.add((MapReduceNodeGroup)nodeGroup);
            return this;
        }

        @Override
        public ClusterBuilder addServiceConfig(String name, ServiceConfig config) {
            if (name != null && !name.isEmpty()) {
                if (this.m.clusterConfigs == null) {
                    this.m.clusterConfigs = new HashMap();
                }
                this.m.clusterConfigs.put(name, (MapReduceServiceConfig)config);
            }
            return this;
        }

        @Override
        public Cluster build() {
            return this.m;
        }

        @Override
        public ClusterBuilder from(Cluster in) {
            this.m = (MapReduceCluster)in;
            return this;
        }
    }

    public static class Clusters
    extends ListResult<MapReduceCluster> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="clusters")
        private List<MapReduceCluster> clusters;

        @Override
        public List<MapReduceCluster> value() {
            return this.clusters;
        }
    }
}

