/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.model.map.reduce.Job;
import com.huawei.openstack4j.model.map.reduce.JobBinary;
import com.huawei.openstack4j.model.map.reduce.builder.JobBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJobBinary;
import java.util.Date;
import java.util.List;

@JsonRootName(value="job")
@JsonIgnoreProperties(ignoreUnknown=true)
public class MapReduceJob
implements Job {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private Job.JobType type;
    @JsonProperty(value="mains")
    private List<MapReduceJobBinary> mains;
    @JsonProperty(value="libs")
    private List<MapReduceJobBinary> libs;
    private List<String> mainBinaryIds;
    private List<String> libBinaryIds;
    private List<String> interfaces;
    @JsonProperty(value="is_protected")
    Boolean isProtected;
    @JsonProperty(value="is_public")
    Boolean isPublic;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Job.JobType getType() {
        return this.type;
    }

    @Override
    public List<? extends JobBinary> getFullMains() {
        return this.mains;
    }

    @Override
    public List<? extends JobBinary> getFullLibs() {
        return this.libs;
    }

    @Override
    public List<String> getMains() {
        return this.mainBinaryIds;
    }

    @Override
    public List<String> getLibs() {
        return this.libBinaryIds;
    }

    @Override
    public List<String> getInterfaces() {
        return this.interfaces;
    }

    @Override
    @JsonIgnore
    public Boolean isProtected() {
        return this.isProtected;
    }

    @Override
    @JsonIgnore
    public Boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public JobBuilder toBuilder() {
        return new ConcreteJobBuilder(this);
    }

    public static JobBuilder builder() {
        return new ConcreteJobBuilder();
    }

    public String toString() {
        return "MapReduceJob(description=" + this.getDescription() + ", url=" + this.url + ", tenantId=" + this.getTenantId() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", id=" + this.getId() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", mains=" + this.getMains() + ", libs=" + this.getLibs() + ", mainBinaryIds=" + this.mainBinaryIds + ", libBinaryIds=" + this.libBinaryIds + ", interfaces=" + this.getInterfaces() + ", isProtected=" + this.isProtected + ", isPublic=" + this.isPublic + ")";
    }

    public static class ConcreteJobBuilder
    implements JobBuilder {
        MapReduceJob m;

        ConcreteJobBuilder() {
            this(new MapReduceJob());
        }

        ConcreteJobBuilder(MapReduceJob m) {
            this.m = m;
        }

        @Override
        public Job build() {
            return this.m;
        }

        @Override
        public JobBuilder from(Job in) {
            this.m = (MapReduceJob)in;
            return this;
        }

        @Override
        public JobBuilder id(String id) {
            this.m.id = id;
            return this;
        }

        @Override
        public JobBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public JobBuilder type(Job.JobType type) {
            this.m.type = type;
            return this;
        }

        @Override
        public JobBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        @JsonProperty(value="mains")
        public JobBuilder addMain(String jobBinaryId) {
            if (this.m.mainBinaryIds == null) {
                this.m.mainBinaryIds = Lists.newArrayList();
            }
            this.m.mainBinaryIds.add(jobBinaryId);
            return this;
        }

        @Override
        @JsonProperty(value="libs")
        public JobBuilder addLib(String jobBinaryId) {
            if (this.m.libBinaryIds == null) {
                this.m.libBinaryIds = Lists.newArrayList();
            }
            this.m.libBinaryIds.add(jobBinaryId);
            return this;
        }

        @Override
        @JsonProperty(value="interfaces")
        public JobBuilder addInterface(String interface_) {
            if (this.m.interfaces == null) {
                this.m.interfaces = Lists.newArrayList();
            }
            this.m.interfaces.add(interface_);
            return this;
        }

        @Override
        public JobBuilder isPublic(boolean isPublic) {
            this.m.isPublic = isPublic;
            return this;
        }

        @Override
        public JobBuilder isProtect(boolean isProtected) {
            this.m.isProtected = isProtected;
            return this;
        }
    }

    public static class Jobs
    extends ListResult<MapReduceJob> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="jobs")
        private List<MapReduceJob> jobs;

        @Override
        protected List<MapReduceJob> value() {
            return this.jobs;
        }
    }
}

