/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.map.reduce.JobConfig;
import com.huawei.openstack4j.model.map.reduce.JobExecution;
import com.huawei.openstack4j.model.map.reduce.JobExecutionInfo;
import com.huawei.openstack4j.model.map.reduce.builder.JobExecutionBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJobConfig;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJobExecutionInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@JsonRootName(value="job_execution")
@JsonIgnoreProperties(value={"jobIdForExecution"}, ignoreUnknown=true)
public class MapReduceJobExecution
implements JobExecution {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="cluster_id")
    private String clusterId;
    @JsonProperty(value="input_id")
    private String inputId;
    @JsonProperty(value="output_id")
    private String outputId;
    @JsonProperty(value="job_configs")
    private MapReduceJobConfig jobConfigs;
    @JsonProperty(value="job_id")
    private String jobId;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="start_time")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date startTime;
    @JsonProperty(value="end_time")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date endTime;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="oozie_job_id")
    private String oozieJobId;
    @JsonProperty(value="return_code")
    private String returnCode;
    @JsonProperty(value="progress")
    private String progress;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="info")
    private MapReduceJobExecutionInfo info;
    private String jobIdForExecute;
    @JsonProperty(value="data_source_urls")
    HashMap<String, String> dataSourceUrls;
    @JsonProperty(value="engine_job_id")
    String engineJobId;
    @JsonProperty(value="is_protected")
    Boolean isProtected;
    @JsonProperty(value="is_public")
    Boolean isPublic;

    @Override
    public String getJobIdForExecution() {
        return this.jobIdForExecute;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getInputId() {
        return this.inputId;
    }

    @Override
    public String getOutputId() {
        return this.outputId;
    }

    @Override
    public JobConfig getJobConfigs() {
        return this.jobConfigs;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getReturnCode() {
        return this.returnCode;
    }

    @Override
    public String getOozieJobId() {
        return this.oozieJobId;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getProgress() {
        return this.progress;
    }

    @Override
    public JobExecutionInfo getInfo() {
        return this.info;
    }

    @Override
    public HashMap<String, String> getDataSourceUrls() {
        return this.dataSourceUrls;
    }

    @Override
    public String getEngineJobId() {
        return this.engineJobId;
    }

    @Override
    @JsonProperty(value="is_protected")
    public Boolean isProtected() {
        return this.isProtected;
    }

    @Override
    @JsonProperty(value="is_public")
    public Boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public JobExecutionBuilder toBuilder() {
        return new ConcreteJobExecutionBuilder(this);
    }

    public static JobExecutionBuilder builder() {
        return new ConcreteJobExecutionBuilder();
    }

    public String toString() {
        return "MapReduceJobExecution(clusterId=" + this.getClusterId() + ", inputId=" + this.getInputId() + ", outputId=" + this.getOutputId() + ", jobConfigs=" + this.getJobConfigs() + ", jobId=" + this.getJobId() + ", tenantId=" + this.getTenantId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", oozieJobId=" + this.getOozieJobId() + ", returnCode=" + this.getReturnCode() + ", progress=" + this.getProgress() + ", id=" + this.getId() + ", info=" + this.getInfo() + ", jobIdForExecute=" + this.jobIdForExecute + ", dataSourceUrls=" + this.getDataSourceUrls() + ", engineJobId=" + this.getEngineJobId() + ", isProtected=" + this.isProtected + ", isPublic=" + this.isPublic + ")";
    }

    public static class ConcreteJobExecutionBuilder
    implements JobExecutionBuilder {
        MapReduceJobExecution m;

        ConcreteJobExecutionBuilder() {
            this(new MapReduceJobExecution());
        }

        ConcreteJobExecutionBuilder(MapReduceJobExecution m) {
            this.m = m;
        }

        @Override
        public JobExecution build() {
            return this.m;
        }

        @Override
        public JobExecutionBuilder from(JobExecution in) {
            this.m = (MapReduceJobExecution)in;
            return this;
        }

        @Override
        public JobExecutionBuilder clusterId(String clusterId) {
            this.m.clusterId = clusterId;
            return this;
        }

        @Override
        public JobExecutionBuilder inputId(String inputId) {
            this.m.inputId = inputId;
            return this;
        }

        @Override
        public JobExecutionBuilder outputId(String outputId) {
            this.m.outputId = outputId;
            return this;
        }

        @Override
        public JobExecutionBuilder setJobConfig(JobConfig jobConfig) {
            this.m.jobConfigs = (MapReduceJobConfig)jobConfig;
            return this;
        }

        @Override
        public JobExecutionBuilder jobId(String jobId) {
            this.m.jobIdForExecute = jobId;
            return this;
        }

        @Override
        public JobExecutionBuilder isPublic(boolean isPublic) {
            this.m.isPublic = isPublic;
            return this;
        }

        @Override
        public JobExecutionBuilder isProtect(boolean isProtected) {
            this.m.isProtected = isProtected;
            return this;
        }

        @Override
        public JobExecutionBuilder engineJobId(String engineJobId) {
            this.m.engineJobId = engineJobId;
            return this;
        }

        @Override
        public JobExecutionBuilder dataSourceUrls(HashMap<String, String> dataSourceUrls) {
            this.m.dataSourceUrls = dataSourceUrls;
            return this;
        }
    }

    public static class JobExecutions
    extends ListResult<MapReduceJobExecution> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="job_executions")
        private List<MapReduceJobExecution> jobExecutions;

        @Override
        public List<MapReduceJobExecution> value() {
            return this.jobExecutions;
        }
    }
}

