/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.model.map.reduce.Instance;
import com.huawei.openstack4j.model.map.reduce.NodeGroup;
import com.huawei.openstack4j.model.map.reduce.ServiceConfig;
import com.huawei.openstack4j.model.map.reduce.builder.NodeGroupBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceInstance;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceServiceConfig;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonRootName(value="node_group")
public class MapReduceNodeGroup
implements NodeGroup {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer count;
    @JsonProperty(value="node_group_template_id")
    private String nodeGroupTemplateId;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="image_id")
    private String imageId;
    @JsonProperty(value="volumes_size")
    private Integer volumesSize;
    @JsonProperty(value="volumes_per_node")
    private Integer volumesPerNode;
    @JsonProperty(value="floating_ip_pool")
    private String floatingNetworkId;
    @JsonProperty(value="flavor_id")
    private String flavorId;
    @JsonProperty(value="volume_mount_prefix")
    private String volumeMountPrefix;
    @JsonProperty(value="auto_security_group")
    private Boolean autoSecurityGroup;
    @JsonProperty(value="security_groups")
    private List<String> securityGroups;
    @JsonProperty(value="node_processes")
    private List<String> nodeProcesses;
    @JsonProperty(value="node_configs")
    private Map<String, MapReduceServiceConfig> serviceConfigs;
    @JsonProperty(value="instances")
    private List<MapReduceInstance> instances;

    @Override
    public NodeGroupBuilder toBuilder() {
        return new ConcreteNodeGroupBuilder(this);
    }

    public static NodeGroupBuilder builder() {
        return new ConcreteNodeGroupBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public String getNodeGroupTemplateId() {
        return this.nodeGroupTemplateId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getFloatingNetworkId() {
        return this.floatingNetworkId;
    }

    @Override
    public Integer getVolumesPerNode() {
        return this.volumesPerNode;
    }

    @Override
    public Integer getVolumesSize() {
        return this.volumesSize;
    }

    @Override
    public String getVolumeMountPrefix() {
        return this.volumeMountPrefix;
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public String getFlavorId() {
        return this.flavorId;
    }

    @Override
    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Override
    public Boolean isAutoSecurityGroup() {
        return this.autoSecurityGroup;
    }

    @Override
    public List<String> getNodeProcesses() {
        return this.nodeProcesses;
    }

    @Override
    public Map<String, ? extends ServiceConfig> getServiceConfigs() {
        return this.serviceConfigs;
    }

    @Override
    public List<? extends Instance> getInstances() {
        return this.instances;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("count", (Object)this.count).add("created_at", (Object)this.createdAt).add("updated_at", (Object)this.updatedAt).add("image_id", (Object)this.imageId).add("volumes_size", (Object)this.volumesSize).add("volumes_per_node", (Object)this.volumesPerNode).add("float_ip_pool", (Object)this.floatingNetworkId).add("flavor_id", (Object)this.flavorId).add("volume_mount_prefix", (Object)this.volumeMountPrefix).add("node_group_template_id", (Object)this.imageId).add("security_groups", this.securityGroups).add("auto_security_group", (Object)this.autoSecurityGroup).add("node_processes", this.nodeProcesses).add("node_configs", this.serviceConfigs).add("instances", this.instances).toString();
    }

    public static class ConcreteNodeGroupBuilder
    implements NodeGroupBuilder {
        private MapReduceNodeGroup m;

        ConcreteNodeGroupBuilder() {
            this(new MapReduceNodeGroup());
        }

        ConcreteNodeGroupBuilder(MapReduceNodeGroup m) {
            this.m = m;
        }

        @Override
        public NodeGroup build() {
            return this.m;
        }

        @Override
        public NodeGroupBuilder from(NodeGroup in) {
            this.m = (MapReduceNodeGroup)in;
            return this;
        }

        @Override
        public NodeGroupBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public NodeGroupBuilder nodeGroupTemplateId(String templateId) {
            this.m.nodeGroupTemplateId = templateId;
            return this;
        }

        @Override
        public NodeGroupBuilder count(int count) {
            this.m.count = count;
            return this;
        }

        @Override
        public NodeGroupBuilder floatingIpPool(String networkId) {
            this.m.floatingNetworkId = networkId;
            return this;
        }

        @Override
        public NodeGroupBuilder flavor(String flavorId) {
            this.m.flavorId = flavorId;
            return this;
        }

        @Override
        public NodeGroupBuilder setAutoSecurityGroup(boolean isAutoSecurityGroup) {
            this.m.autoSecurityGroup = isAutoSecurityGroup;
            return this;
        }

        @Override
        public NodeGroupBuilder addSecurityGroup(String id) {
            if (id != null && !id.isEmpty()) {
                if (this.m.securityGroups == null) {
                    this.m.securityGroups = Lists.newArrayList();
                }
                this.m.securityGroups.add(id);
            }
            return this;
        }

        @Override
        public NodeGroupBuilder addNodeProcess(String name) {
            if (name != null && !name.isEmpty()) {
                if (this.m.nodeProcesses == null) {
                    this.m.nodeProcesses = Lists.newArrayList();
                }
                this.m.nodeProcesses.add(name);
            }
            return this;
        }

        @Override
        public NodeGroupBuilder addServiceConfig(String name, ServiceConfig config) {
            if (name != null && !name.isEmpty()) {
                if (this.m.serviceConfigs == null) {
                    this.m.serviceConfigs = new HashMap();
                }
                this.m.serviceConfigs.put(name, (MapReduceServiceConfig)config);
            }
            return this;
        }
    }

    public static class NodeGroups
    extends ListResult<MapReduceNodeGroup> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="node_groups")
        private List<MapReduceNodeGroup> nodeGroups;

        @Override
        protected List<MapReduceNodeGroup> value() {
            return this.nodeGroups;
        }
    }
}

