/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.map.reduce.MapReducePluginService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.common.Payload;
import com.huawei.openstack4j.model.map.reduce.ClusterTemplate;
import com.huawei.openstack4j.model.map.reduce.Plugin;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceClusterTemplate;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReducePlugin;
import com.huawei.openstack4j.openstack.map.reduce.internal.BaseMapReduceServices;
import java.util.List;

public class MapReducePluginServiceImpl
extends BaseMapReduceServices
implements MapReducePluginService {
    @Override
    public List<? extends Plugin> list() {
        return this.get(MapReducePlugin.MapReducePlugins.class, this.uri("/plugins", new Object[0])).execute().getList();
    }

    @Override
    public Plugin get(String name) {
        Preconditions.checkNotNull((Object)name);
        return this.get(MapReducePlugin.class, this.uri("/plugins/%s", name)).execute();
    }

    @Override
    public Plugin get(String name, String version) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)version);
        return this.get(MapReducePlugin.class, this.uri("/plugins/%s/%s", name, version)).execute();
    }

    @Override
    public ClusterTemplate convertConfig(String name, String version, String templateName, Payload<?> payload) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)version);
        Preconditions.checkNotNull((Object)templateName);
        return this.post(MapReduceClusterTemplate.class, this.uri("/plugins/%s/%s/convert-config/%s", name, version, templateName)).entity(payload).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

