/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.notification.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.message.notification.constant.Protocol;
import com.huawei.openstack4j.openstack.message.notification.constant.SubscriptionStatus;
import com.huawei.openstack4j.openstack.message.notification.domain.TracableRequest;
import java.beans.ConstructorProperties;
import java.util.List;

public class Subscription
extends TracableRequest
implements ModelEntity {
    private static final long serialVersionUID = -6764087311133427927L;
    @JsonProperty(value="subscription_urn")
    String urn;
    @JsonProperty(value="topic_urn")
    String topicUrn;
    @JsonProperty(value="protocol")
    Protocol protocol;
    @JsonProperty(value="owner")
    String owner;
    @JsonProperty(value="endpoint")
    String endpoint;
    @JsonProperty(value="remark")
    String remark;
    @JsonProperty(value="status")
    SubscriptionStatus status;

    public static SubscriptionBuilder builder() {
        return new SubscriptionBuilder();
    }

    public SubscriptionBuilder toBuilder() {
        return new SubscriptionBuilder().urn(this.urn).topicUrn(this.topicUrn).protocol(this.protocol).owner(this.owner).endpoint(this.endpoint).remark(this.remark).status(this.status);
    }

    public String getUrn() {
        return this.urn;
    }

    public String getTopicUrn() {
        return this.topicUrn;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRemark() {
        return this.remark;
    }

    public SubscriptionStatus getStatus() {
        return this.status;
    }

    public String toString() {
        return "Subscription(urn=" + this.getUrn() + ", topicUrn=" + this.getTopicUrn() + ", protocol=" + (Object)((Object)this.getProtocol()) + ", owner=" + this.getOwner() + ", endpoint=" + this.getEndpoint() + ", remark=" + this.getRemark() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public Subscription() {
    }

    @ConstructorProperties(value={"urn", "topicUrn", "protocol", "owner", "endpoint", "remark", "status"})
    public Subscription(String urn, String topicUrn, Protocol protocol, String owner, String endpoint, String remark, SubscriptionStatus status) {
        this.urn = urn;
        this.topicUrn = topicUrn;
        this.protocol = protocol;
        this.owner = owner;
        this.endpoint = endpoint;
        this.remark = remark;
        this.status = status;
    }

    public static class SubscriptionBuilder {
        private String urn;
        private String topicUrn;
        private Protocol protocol;
        private String owner;
        private String endpoint;
        private String remark;
        private SubscriptionStatus status;

        SubscriptionBuilder() {
        }

        public SubscriptionBuilder urn(String urn) {
            this.urn = urn;
            return this;
        }

        public SubscriptionBuilder topicUrn(String topicUrn) {
            this.topicUrn = topicUrn;
            return this;
        }

        public SubscriptionBuilder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public SubscriptionBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public SubscriptionBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public SubscriptionBuilder remark(String remark) {
            this.remark = remark;
            return this;
        }

        public SubscriptionBuilder status(SubscriptionStatus status) {
            this.status = status;
            return this;
        }

        public Subscription build() {
            return new Subscription(this.urn, this.topicUrn, this.protocol, this.owner, this.endpoint, this.remark, this.status);
        }

        public String toString() {
            return "Subscription.SubscriptionBuilder(urn=" + this.urn + ", topicUrn=" + this.topicUrn + ", protocol=" + (Object)((Object)this.protocol) + ", owner=" + this.owner + ", endpoint=" + this.endpoint + ", remark=" + this.remark + ", status=" + (Object)((Object)this.status) + ")";
        }
    }

    public static class Subscriptions
    extends ListResult<Subscription> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="subscriptions")
        private List<Subscription> subscriptions;
        @JsonProperty(value="request_id")
        String requestId;

        @Override
        public List<Subscription> value() {
            return this.subscriptions;
        }

        public String getRequestId() {
            return this.requestId;
        }
    }
}

