/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.notification.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.openstack.message.notification.domain.MessageTemplate;
import com.huawei.openstack4j.openstack.message.notification.domain.MessageTemplateCreate;
import com.huawei.openstack4j.openstack.message.notification.domain.TracableRequest;
import com.huawei.openstack4j.openstack.message.notification.internal.BaseNotificationServices;
import com.huawei.openstack4j.openstack.message.notification.options.MessageTemplateListOptions;
import java.util.List;
import java.util.Map;

public class MessageTemplateService
extends BaseNotificationServices
implements RestService {
    public List<? extends MessageTemplate> list(MessageTemplateListOptions options) {
        Map<String, Object> params = options == null ? null : options.getOptions();
        return this.get(MessageTemplate.MessageTemplates.class, this.uri("/notifications/message_template", new Object[0])).params(params).execute().getList();
    }

    public MessageTemplate get(String messageTemplateId) {
        Preconditions.checkNotNull((Object)messageTemplateId, (Object)"parameter `messageTemplateId` should not be empty");
        return this.get(MessageTemplate.class, "/notifications/message_template/", messageTemplateId).execute();
    }

    public MessageTemplate create(MessageTemplateCreate create) {
        Preconditions.checkNotNull((Object)create, (Object)"parameter `create` should not be null");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)create.getName()) ? 1 : 0), (Object)"parameter `create.name` should not be null");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)create.getContent()) ? 1 : 0), (Object)"parameter `create.content` should not be null");
        Preconditions.checkNotNull((Object)((Object)create.getProtocol()), (Object)"parameter `create.protocol` should not be null");
        return this.post(MessageTemplate.class, this.uri("/notifications/message_template", new Object[0])).entity(create).execute();
    }

    public TracableRequest updateContent(String messageTemplateId, String content) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)messageTemplateId) ? 1 : 0), (Object)"parameter `messageTemplateId` should not be empty");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)content) ? 1 : 0), (Object)"parameter `content` should not be empty");
        MessageTemplate update = MessageTemplate.builder().content(content).build();
        return this.put(TracableRequest.class, "/notifications/message_template/", messageTemplateId).entity(update).execute();
    }

    public TracableRequest delete(String messageTemplateId) {
        Preconditions.checkNotNull((Object)messageTemplateId, (Object)"parameter `messageTemplateId` should not be empty");
        return this.delete(TracableRequest.class, "/notifications/message_template/", messageTemplateId).execute();
    }
}

