/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.notification.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.openstack.message.notification.domain.MessageIdResponse;
import com.huawei.openstack4j.openstack.message.notification.internal.BaseNotificationServices;
import java.util.HashMap;

public class SmsService
extends BaseNotificationServices
implements RestService {
    public MessageIdResponse send(String receiver, String message, String smsSignId) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)receiver) ? 1 : 0), (Object)"parameter `receiver` should not be null");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)message) ? 1 : 0), (Object)"parameter `message` should not be null");
        if (!receiver.startsWith("+")) {
            receiver = "+" + receiver;
        }
        HashMap body = Maps.newHashMap();
        body.put("endpoint", receiver);
        body.put("message", message);
        if (!Strings.isNullOrEmpty((String)smsSignId)) {
            body.put("sign_id", smsSignId);
        }
        return this.post(MessageIdResponse.class, this.uri("/notifications/sms", new Object[0])).entity(body).execute();
    }
}

