/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.notification.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.openstack.message.notification.domain.Subscription;
import com.huawei.openstack4j.openstack.message.notification.domain.SubscriptionCreate;
import com.huawei.openstack4j.openstack.message.notification.domain.TracableRequest;
import com.huawei.openstack4j.openstack.message.notification.internal.BaseNotificationServices;
import java.util.List;

public class SubscriptionService
extends BaseNotificationServices
implements RestService {
    public List<? extends Subscription> list(Integer limit, Integer offset) {
        return this.get(Subscription.Subscriptions.class, this.uri("/notifications/subscriptions", new Object[0])).param("limit", limit).param("offset", offset).execute().getList();
    }

    public List<? extends Subscription> listByTopic(String topicUrn, Integer limit, Integer offset) {
        Preconditions.checkNotNull((Object)topicUrn, (Object)"parameter `topicUrn` should not be null");
        return this.get(Subscription.Subscriptions.class, this.uri("/notifications/topics/%s/subscriptions", topicUrn)).param("limit", limit).param("offset", offset).execute().getList();
    }

    public Subscription subscribe(SubscriptionCreate subscribe) {
        Preconditions.checkNotNull((Object)subscribe, (Object)"parameter `subscribe` should not be null");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)subscribe.getTopicUrn()) ? 1 : 0), (Object)"parameter `subscribe.topicUrn` should not be empty");
        Preconditions.checkNotNull((Object)((Object)subscribe.getProtocol()), (Object)"parameter `subscribe.protocol` should not be empty");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)subscribe.getEndpoint()) ? 1 : 0), (Object)"parameter `subscribe.endpoint` should not be empty");
        return this.post(Subscription.class, this.uri("/notifications/topics/%s/subscriptions", subscribe.getTopicUrn())).entity(subscribe).execute();
    }

    public TracableRequest unsubscribe(String subscriptionUrn) {
        Preconditions.checkNotNull((Object)subscriptionUrn, (Object)"parameter `subscriptionUrn` should not be empty");
        return this.delete(TracableRequest.class, this.uri("/notifications/subscriptions/%s", subscriptionUrn)).execute();
    }
}

