/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.queue.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.message.queue.domain.QueueMessage;
import java.beans.ConstructorProperties;
import java.util.List;

public class QueueMessageWithHandler
implements ModelEntity {
    private static final long serialVersionUID = -6764087311133427927L;
    @JsonProperty(value="message")
    QueueMessage message;
    @JsonProperty(value="handler")
    String handler;

    public static QueueMessageWithHandlerBuilder builder() {
        return new QueueMessageWithHandlerBuilder();
    }

    public QueueMessageWithHandlerBuilder toBuilder() {
        return new QueueMessageWithHandlerBuilder().message(this.message).handler(this.handler);
    }

    public QueueMessage getMessage() {
        return this.message;
    }

    public String getHandler() {
        return this.handler;
    }

    public String toString() {
        return "QueueMessageWithHandler(message=" + this.getMessage() + ", handler=" + this.getHandler() + ")";
    }

    public QueueMessageWithHandler() {
    }

    @ConstructorProperties(value={"message", "handler"})
    public QueueMessageWithHandler(QueueMessage message, String handler) {
        this.message = message;
        this.handler = handler;
    }

    public static class QueueMessageWithHandlerBuilder {
        private QueueMessage message;
        private String handler;

        QueueMessageWithHandlerBuilder() {
        }

        public QueueMessageWithHandlerBuilder message(QueueMessage message) {
            this.message = message;
            return this;
        }

        public QueueMessageWithHandlerBuilder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public QueueMessageWithHandler build() {
            return new QueueMessageWithHandler(this.message, this.handler);
        }

        public String toString() {
            return "QueueMessageWithHandler.QueueMessageWithHandlerBuilder(message=" + this.message + ", handler=" + this.handler + ")";
        }
    }

    public static class QueueMessageWithHandlers
    extends ListResult<QueueMessageWithHandler> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="messages")
        private List<QueueMessageWithHandler> messages = Lists.newArrayList();

        @Override
        public List<QueueMessageWithHandler> value() {
            return this.messages;
        }

        @JsonCreator
        public QueueMessageWithHandlers(List<QueueMessageWithHandler> messages) {
            this.messages = messages;
        }
    }
}

