/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.queue.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.message.queue.constant.ConsumeStatus;
import com.huawei.openstack4j.openstack.message.queue.domain.ConsumeConfirm;
import com.huawei.openstack4j.openstack.message.queue.domain.ConsumeConfirmResponse;
import com.huawei.openstack4j.openstack.message.queue.domain.QueueMessage;
import com.huawei.openstack4j.openstack.message.queue.domain.QueueMessageWithHandler;
import com.huawei.openstack4j.openstack.message.queue.internal.BaseMessageQueueServices;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueueMessageService
extends BaseMessageQueueServices
implements RestService {
    public ActionResponse produce(String queueId, QueueMessage message) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)queueId) ? 1 : 0), (Object)"parameter `queueId` should not be empty");
        Preconditions.checkNotNull((Object)message, (Object)"parameter `message` should not be null");
        Preconditions.checkNotNull((Object)message.getBody(), (Object)"parameter `message.body` should not be null");
        return this.produce(queueId, Lists.newArrayList((Object[])new QueueMessage[]{message}));
    }

    public ActionResponse produce(String queueId, List<QueueMessage> messages) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)queueId) ? 1 : 0), (Object)"parameter `queueId` should not be empty");
        Preconditions.checkArgument((messages != null && messages.size() > 0 ? 1 : 0) != 0, (Object)"parameter `message` should not be empty");
        for (int i = 0; i < messages.size(); ++i) {
            QueueMessage message = messages.get(i);
            Preconditions.checkNotNull((Object)message, (Object)String.format("the item at position %d of message is invalid", i));
            Preconditions.checkNotNull((Object)message.getBody(), (Object)String.format("the item at position %d of message is invalid", i));
        }
        QueueMessage.QueueMessages body = new QueueMessage.QueueMessages(messages);
        return this.postWithResponse(this.uri("/queues/%s/messages", queueId)).entity(body).execute();
    }

    public List<QueueMessageWithHandler> consume(String queueId, String consumerGroupId, Integer maxMessages, Integer timeWait) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)queueId) ? 1 : 0), (Object)"parameter `queueId` should not be empty");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)consumerGroupId) ? 1 : 0), (Object)"parameter `consumerGroupId` should not be empty");
        return this.get(QueueMessageWithHandler.QueueMessageWithHandlers.class, this.uri("/queues/%s/groups/%s/messages", queueId, consumerGroupId)).param("max_msgs", maxMessages).param("time_wait", timeWait).execute().getList();
    }

    public ConsumeConfirmResponse confirmConsuming(String queueId, String consumerGroupId, Map<String, ConsumeStatus> consumeResult) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)queueId) ? 1 : 0), (Object)"parameter `queueId` should not be empty");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)consumerGroupId) ? 1 : 0), (Object)"parameter `consumerGroupId` should not be empty");
        Preconditions.checkArgument((consumeResult != null && consumeResult.size() > 0 ? 1 : 0) != 0, (Object)"parameter `consumeResult` should not be empty");
        ArrayList<ConsumeConfirm> confirms = new ArrayList<ConsumeConfirm>();
        for (Map.Entry<String, ConsumeStatus> entry : consumeResult.entrySet()) {
            String handler = entry.getKey();
            ConsumeStatus status = entry.getValue();
            Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)handler) ? 1 : 0), (Object)"parameter `consumeResult` contains illegal key");
            Preconditions.checkNotNull((Object)((Object)status), (Object)"parameter `consumeResult` contains illegal value");
            ConsumeConfirm confirm = ConsumeConfirm.builder().handler(handler).status(status).build();
            confirms.add(confirm);
        }
        HashMap body = Maps.newHashMap();
        body.put("message", confirms);
        return this.post(ConsumeConfirmResponse.class, this.uri("/queues/%s/groups/%s/ack", queueId, consumerGroupId)).entity(body).execute();
    }
}

