/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.nat.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.nat.DnatRuleService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.nat.domain.DnatRule;
import com.huawei.openstack4j.openstack.nat.domain.DnatRuleCreate;
import com.huawei.openstack4j.openstack.nat.internal.BaseNatServices;
import java.util.List;
import java.util.Map;

public class DnatRuleServiceImpl
extends BaseNatServices
implements DnatRuleService {
    private static final String API_PATH = "/dnat_rules";

    @Override
    public DnatRule create(DnatRuleCreate dNatRuleCreate) {
        return this.post(DnatRule.class, this.uri(API_PATH, new Object[0])).entity(dNatRuleCreate).execute();
    }

    @Override
    public List<DnatRule> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<DnatRule.DNatRules> req = this.get(DnatRule.DNatRules.class, this.uri(API_PATH, new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public List<DnatRule> list() {
        return this.get(DnatRule.DNatRules.class, this.uri(API_PATH, new Object[0])).execute().getList();
    }

    @Override
    public DnatRule get(String dnatRuleId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dnatRuleId) ? 1 : 0) != 0, (Object)"parameter `dnatRuleId` should not be empty");
        return this.get(DnatRule.class, this.uri("/dnat_rules/%s", dnatRuleId)).execute();
    }

    @Override
    public ActionResponse delete(String dnatRuleId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dnatRuleId) ? 1 : 0) != 0, (Object)"parameter `dnatRuleId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/dnat_rules/%s", dnatRuleId)).executeWithResponse());
    }
}

