/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.nat.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.nat.SnatRulesService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.nat.domain.SnatRule;
import com.huawei.openstack4j.openstack.nat.domain.SnatRuleCreate;
import com.huawei.openstack4j.openstack.nat.internal.BaseNatServices;
import java.util.List;
import java.util.Map;

public class SnatRulesServiceImpl
extends BaseNatServices
implements SnatRulesService {
    private static final String API_PATH = "/snat_rules";

    @Override
    public SnatRule create(SnatRuleCreate model) {
        return this.post(SnatRule.class, this.uri(API_PATH, new Object[0])).entity(model).execute();
    }

    @Override
    public List<SnatRule> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<SnatRule.SnatRules> req = this.get(SnatRule.SnatRules.class, this.uri(API_PATH, new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public SnatRule get(String snatRuleId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snatRuleId) ? 1 : 0) != 0, (Object)"parameter `snatRuleId` should not be empty");
        return this.get(SnatRule.class, this.uri("/snat_rules/%s", snatRuleId)).execute();
    }

    @Override
    public ActionResponse delete(String snatRuleId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snatRuleId) ? 1 : 0) != 0, (Object)"parameter `snatRuleId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/snat_rules/%s", snatRuleId)).executeWithResponse());
    }

    @Override
    public List<SnatRule> list() {
        return this.get(SnatRule.SnatRules.class, this.uri(API_PATH, new Object[0])).execute().getList();
    }
}

