/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="ikepolicy")
public class IKEPolicy
implements ModelEntity {
    private static final long serialVersionUID = -5424079089711176060L;
    @JsonProperty
    private String name;
    @JsonProperty(value="auth_algorithm")
    private String authAlgorithm;
    @JsonProperty
    private String description;
    @JsonProperty(value="encryption_algorithm")
    private String encryptionAlgorithm;
    @JsonProperty(value="ike_version")
    private IkeVersion ikeVersion;
    @JsonProperty
    private LifeTime lifetime;
    @JsonProperty
    private Pfs pfs;
    @JsonProperty(value="phase1_negotiation_mode")
    private String phase1NegotiationMode;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty
    private String value;
    @JsonProperty
    private String units;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty
    private String id;

    private static IkeVersion $default$ikeVersion() {
        return IkeVersion.V1;
    }

    private static Pfs $default$pfs() {
        return Pfs.group5;
    }

    public static IKEPolicyBuilder builder() {
        return new IKEPolicyBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getAuthAlgorithm() {
        return this.authAlgorithm;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public IkeVersion getIkeVersion() {
        return this.ikeVersion;
    }

    public LifeTime getLifetime() {
        return this.lifetime;
    }

    public Pfs getPfs() {
        return this.pfs;
    }

    public String getPhase1NegotiationMode() {
        return this.phase1NegotiationMode;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getValue() {
        return this.value;
    }

    public String getUnits() {
        return this.units;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "IKEPolicy(name=" + this.getName() + ", authAlgorithm=" + this.getAuthAlgorithm() + ", description=" + this.getDescription() + ", encryptionAlgorithm=" + this.getEncryptionAlgorithm() + ", ikeVersion=" + (Object)((Object)this.getIkeVersion()) + ", lifetime=" + this.getLifetime() + ", pfs=" + (Object)((Object)this.getPfs()) + ", phase1NegotiationMode=" + this.getPhase1NegotiationMode() + ", tenantId=" + this.getTenantId() + ", value=" + this.getValue() + ", units=" + this.getUnits() + ", projectId=" + this.getProjectId() + ", id=" + this.getId() + ")";
    }

    public IKEPolicy() {
    }

    @ConstructorProperties(value={"name", "authAlgorithm", "description", "encryptionAlgorithm", "ikeVersion", "lifetime", "pfs", "phase1NegotiationMode", "tenantId", "value", "units", "projectId", "id"})
    public IKEPolicy(String name, String authAlgorithm, String description, String encryptionAlgorithm, IkeVersion ikeVersion, LifeTime lifetime, Pfs pfs, String phase1NegotiationMode, String tenantId, String value, String units, String projectId, String id) {
        this.name = name;
        this.authAlgorithm = authAlgorithm;
        this.description = description;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.ikeVersion = ikeVersion;
        this.lifetime = lifetime;
        this.pfs = pfs;
        this.phase1NegotiationMode = phase1NegotiationMode;
        this.tenantId = tenantId;
        this.value = value;
        this.units = units;
        this.projectId = projectId;
        this.id = id;
    }

    public static class IKEPolicyBuilder {
        private String name;
        private String authAlgorithm;
        private String description;
        private String encryptionAlgorithm;
        private boolean ikeVersion$set;
        private IkeVersion ikeVersion;
        private LifeTime lifetime;
        private boolean pfs$set;
        private Pfs pfs;
        private String phase1NegotiationMode;
        private String tenantId;
        private String value;
        private String units;
        private String projectId;
        private String id;

        IKEPolicyBuilder() {
        }

        public IKEPolicyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public IKEPolicyBuilder authAlgorithm(String authAlgorithm) {
            this.authAlgorithm = authAlgorithm;
            return this;
        }

        public IKEPolicyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public IKEPolicyBuilder encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        public IKEPolicyBuilder ikeVersion(IkeVersion ikeVersion) {
            this.ikeVersion = ikeVersion;
            this.ikeVersion$set = true;
            return this;
        }

        public IKEPolicyBuilder lifetime(LifeTime lifetime) {
            this.lifetime = lifetime;
            return this;
        }

        public IKEPolicyBuilder pfs(Pfs pfs) {
            this.pfs = pfs;
            this.pfs$set = true;
            return this;
        }

        public IKEPolicyBuilder phase1NegotiationMode(String phase1NegotiationMode) {
            this.phase1NegotiationMode = phase1NegotiationMode;
            return this;
        }

        public IKEPolicyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public IKEPolicyBuilder value(String value) {
            this.value = value;
            return this;
        }

        public IKEPolicyBuilder units(String units) {
            this.units = units;
            return this;
        }

        public IKEPolicyBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public IKEPolicyBuilder id(String id) {
            this.id = id;
            return this;
        }

        public IKEPolicy build() {
            return new IKEPolicy(this.name, this.authAlgorithm, this.description, this.encryptionAlgorithm, this.ikeVersion$set ? this.ikeVersion : IKEPolicy.$default$ikeVersion(), this.lifetime, this.pfs$set ? this.pfs : IKEPolicy.$default$pfs(), this.phase1NegotiationMode, this.tenantId, this.value, this.units, this.projectId, this.id);
        }

        public String toString() {
            return "IKEPolicy.IKEPolicyBuilder(name=" + this.name + ", authAlgorithm=" + this.authAlgorithm + ", description=" + this.description + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ", ikeVersion=" + (Object)((Object)this.ikeVersion) + ", lifetime=" + this.lifetime + ", pfs=" + (Object)((Object)this.pfs) + ", phase1NegotiationMode=" + this.phase1NegotiationMode + ", tenantId=" + this.tenantId + ", value=" + this.value + ", units=" + this.units + ", projectId=" + this.projectId + ", id=" + this.id + ")";
        }
    }

    public static enum Pfs {
        group2,
        group5,
        group14;


        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static Pfs value(String v) {
            try {
                return Pfs.valueOf(v.toLowerCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    public static enum IkeVersion {
        V1,
        V2;


        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static IkeVersion value(String v) {
            try {
                return IkeVersion.valueOf(v.toLowerCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    @JsonRootName(value="lifeTime")
    public static class LifeTime {
        private String units;
        private Integer value;

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public LifeTime() {
        }

        @ConstructorProperties(value={"units", "value"})
        public LifeTime(String units, Integer value) {
            this.units = units;
            this.value = value;
        }
    }

    public static class IKEPolicies
    extends ListResult<IKEPolicy> {
        private static final long serialVersionUID = -38195172842707313L;
        @JsonProperty
        private List<IKEPolicy> ikePolicies;

        @Override
        protected List<IKEPolicy> value() {
            return this.ikePolicies;
        }
    }
}

