/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.network.Agent;
import com.huawei.openstack4j.model.network.builder.AgentBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.internal.Parser;
import java.util.Date;
import java.util.List;

@JsonRootName(value="agent")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronAgent
implements Agent {
    private static final long serialVersionUID = 1L;
    private String binary;
    private String description;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;
    @JsonProperty(value="heartbeat_timestamp")
    private String heartbeatTimeStamp;
    private boolean alive;
    private String topic;
    private String host;
    @JsonProperty(value="agent_type")
    private Agent.Type agentType;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="started_at")
    private String startedAt;
    private String id;

    @Override
    public boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public Agent.Type getAgentType() {
        return this.agentType;
    }

    @Override
    public boolean getAlive() {
        return this.alive;
    }

    @Override
    public String getBinary() {
        return this.binary;
    }

    @Override
    public Date getCreatedAt() {
        return Parser.parseSimpleDate(this.createdAt);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Date getHeartbeatTimestamp() {
        return Parser.parseSimpleDate(this.heartbeatTimeStamp);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getStartedAt() {
        return Parser.parseSimpleDate(this.startedAt);
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("binary", (Object)this.binary).add("description", (Object)this.description).add("admin_state_up", this.adminStateUp).add("heartbeat_timestamp", (Object)this.heartbeatTimeStamp).add("alive", this.alive).add("topic", (Object)this.topic).add("host", (Object)this.host).add("agent_type", (Object)this.agentType.value()).add("created_at", (Object)this.createdAt).add("started_at", (Object)this.startedAt).toString();
    }

    public static AgentBuilder builder() {
        return new AgentConcreteBuilder();
    }

    @Override
    public AgentBuilder toBuilder() {
        return new AgentConcreteBuilder(this);
    }

    public static class AgentConcreteBuilder
    implements AgentBuilder {
        private NeutronAgent model;

        AgentConcreteBuilder() {
            this(new NeutronAgent());
        }

        AgentConcreteBuilder(NeutronAgent model) {
            this.model = model;
        }

        public AgentBuilder name() {
            return this;
        }

        @Override
        public Agent build() {
            return this.model;
        }

        @Override
        public AgentBuilder from(Agent in) {
            this.model = (NeutronAgent)in;
            return this;
        }

        @Override
        public AgentBuilder adminStateUp(boolean state) {
            this.model.adminStateUp = state;
            return this;
        }
    }

    public static class Agents
    extends ListResult<NeutronAgent> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="agents")
        private List<NeutronAgent> agents;

        @Override
        public List<NeutronAgent> value() {
            return this.agents;
        }
    }
}

