/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.network.ext.HealthMonitorType;
import com.huawei.openstack4j.model.network.ext.HealthMonitorV2;
import com.huawei.openstack4j.model.network.ext.builder.HealthMonitorV2Builder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.networking.domain.ext.ListItem;
import java.util.List;

@JsonRootName(value="healthmonitor")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronHealthMonitorV2
implements HealthMonitorV2 {
    private static final long serialVersionUID = 9071758730127536056L;
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private HealthMonitorType type;
    private Integer delay;
    private Integer timeout;
    private String name;
    @JsonProperty(value="max_retries")
    private Integer maxRetries;
    @JsonProperty(value="http_method")
    private httpMethodType httpMethod;
    @JsonProperty(value="url_path")
    private String urlPath;
    @JsonProperty(value="expected_codes")
    private String expectedCodes;
    @JsonProperty(value="admin_state_up")
    private Boolean adminStateUp = true;
    private List<ListItem> pools;
    @JsonProperty(value="pool_id")
    private String poolId;
    @JsonProperty(value="monitor_port")
    private Integer monitorPort;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public HealthMonitorType getType() {
        return this.type;
    }

    @Override
    public Integer getDelay() {
        return this.delay;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public httpMethodType getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getUrlPath() {
        return this.urlPath;
    }

    @Override
    public String getExpectedCodes() {
        return this.expectedCodes;
    }

    @Override
    public Boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public List<ListItem> getPools() {
        return this.pools;
    }

    @Override
    public Integer getMonitorPort() {
        return this.monitorPort;
    }

    @Override
    public HealthMonitorV2Builder toBuilder() {
        return new HealthMonitorV2Concretebuilder(this);
    }

    public static HealthMonitorV2Builder builder() {
        return new HealthMonitorV2Concretebuilder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("tenantId", (Object)this.tenantId).add("type", (Object)this.type).add("delay", (Object)this.delay).add("name", (Object)this.name).add("timeout", (Object)this.timeout).add("maxRetries", (Object)this.maxRetries).add("httpMethod", (Object)this.httpMethod).add("urlPath", (Object)this.urlPath).add("expectedCodes", (Object)this.expectedCodes).add("adminStateUp", (Object)this.adminStateUp).add("pools", this.pools).add("poolId", (Object)this.poolId).add("monitorPort", (Object)this.monitorPort).toString();
    }

    public static enum httpMethodType {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        TRACE,
        OPTIONS,
        CONNECT,
        PATCH;


        @JsonValue
        public String value() {
            return this.name().toUpperCase();
        }

        @JsonCreator
        public static httpMethodType value(String v) {
            try {
                return httpMethodType.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    public static class HealthMonitorV2Concretebuilder
    implements HealthMonitorV2Builder {
        NeutronHealthMonitorV2 m;

        @Override
        public HealthMonitorV2 build() {
            return this.m;
        }

        public HealthMonitorV2Concretebuilder() {
            this(new NeutronHealthMonitorV2());
        }

        public HealthMonitorV2Concretebuilder(NeutronHealthMonitorV2 m) {
            this.m = m;
        }

        @Override
        public HealthMonitorV2Builder from(HealthMonitorV2 in) {
            this.m = (NeutronHealthMonitorV2)in;
            return this;
        }

        @Override
        public HealthMonitorV2Builder tenantId(String tenantId) {
            this.m.tenantId = tenantId;
            return this;
        }

        @Override
        public HealthMonitorV2Builder monitorPort(Integer monitorPort) {
            this.m.monitorPort = monitorPort;
            return this;
        }

        @Override
        public HealthMonitorV2Builder type(HealthMonitorType type) {
            this.m.type = type;
            return this;
        }

        @Override
        public HealthMonitorV2Builder delay(Integer delay) {
            this.m.delay = delay;
            return this;
        }

        @Override
        public HealthMonitorV2Builder timeout(Integer timeout) {
            this.m.timeout = timeout;
            return this;
        }

        @Override
        public HealthMonitorV2Builder maxRetries(Integer maxRetries) {
            this.m.maxRetries = maxRetries;
            return this;
        }

        @Override
        public HealthMonitorV2Builder urlPath(String urlPath) {
            this.m.urlPath = urlPath;
            return this;
        }

        @Override
        public HealthMonitorV2Builder expectedCodes(String expectedCodes) {
            this.m.expectedCodes = expectedCodes;
            return this;
        }

        @Override
        public HealthMonitorV2Builder httpMethod(httpMethodType httpMethod) {
            this.m.httpMethod = httpMethod;
            return this;
        }

        @Override
        public HealthMonitorV2Builder adminStateUp(Boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public HealthMonitorV2Builder poolId(String poolId) {
            this.m.poolId = poolId;
            return this;
        }

        @Override
        public HealthMonitorV2Builder name(String name) {
            this.m.name = name;
            return this;
        }
    }

    public static class HealthMonitorsV2
    extends ListResult<NeutronHealthMonitorV2> {
        @JsonProperty(value="healthmonitors")
        List<NeutronHealthMonitorV2> healthMonitors;

        @Override
        public List<NeutronHealthMonitorV2> value() {
            return this.healthMonitors;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("healthMonitors", this.healthMonitors).toString();
        }
    }
}

