/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.networking.ext.IpsecPolicyService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.networking.domain.NeutronIpsecPolicy;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;

public class IpsecPolicyServiceImpl
extends BaseNetworkingServices
implements IpsecPolicyService {
    private static final String API_PATH = "/vpn/ipsecpolicies";
    private static final String filter = "fields";

    @Override
    public NeutronIpsecPolicy create(NeutronIpsecPolicy model) {
        return this.post(NeutronIpsecPolicy.class, this.uri(API_PATH, new Object[0])).entity(model).execute();
    }

    @Override
    public List<NeutronIpsecPolicy> list(String field) {
        return this.get(NeutronIpsecPolicy.NeutronIpsecPolicies.class, this.uri(API_PATH, new Object[0])).param(filter, field).execute().getList();
    }

    @Override
    public NeutronIpsecPolicy get(String policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"parameter `policyId` should not be empty");
        return this.get(NeutronIpsecPolicy.class, this.uri("/vpn/ipsecpolicies/%s", policyId)).execute();
    }

    @Override
    public ActionResponse delete(String policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"parameter `policyId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vpn/ipsecpolicies/%s", policyId)).executeWithResponse());
    }

    @Override
    public NeutronIpsecPolicy update(String policyId, NeutronIpsecPolicy model) {
        Preconditions.checkArgument((null != model ? 1 : 0) != 0, (Object)"parameter `model` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"parameter `policyId` should not be empty");
        return this.put(NeutronIpsecPolicy.class, this.uri("/vpn/ipsecpolicies/%s", policyId)).entity(model).execute();
    }
}

