/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.networking.RouterService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.network.AttachInterfaceType;
import com.huawei.openstack4j.model.network.HostRoute;
import com.huawei.openstack4j.model.network.Router;
import com.huawei.openstack4j.model.network.RouterInterface;
import com.huawei.openstack4j.model.network.builder.RouterBuilder;
import com.huawei.openstack4j.openstack.networking.domain.AddRouterInterfaceAction;
import com.huawei.openstack4j.openstack.networking.domain.NeutronRouter;
import com.huawei.openstack4j.openstack.networking.domain.NeutronRouterInterface;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;

public class RouterServiceImpl
extends BaseNetworkingServices
implements RouterService {
    @Override
    public List<? extends Router> list() {
        return this.get(NeutronRouter.Routers.class, this.uri("/routers", new Object[0])).execute().getList();
    }

    @Override
    public Router get(String routerId) {
        Preconditions.checkNotNull((Object)routerId);
        return this.get(NeutronRouter.class, this.uri("/routers/%s", routerId)).execute();
    }

    @Override
    public ActionResponse delete(String routerId) {
        Preconditions.checkNotNull((Object)routerId);
        return this.deleteWithResponse(this.uri("/routers/%s", routerId)).execute();
    }

    @Override
    public Router create(String name, boolean adminStateUp) {
        Preconditions.checkNotNull((Object)name);
        return this.post(NeutronRouter.class, this.uri("/routers", new Object[0])).entity(NeutronRouter.builder().name(name).adminStateUp(adminStateUp).build()).execute();
    }

    @Override
    public Router create(Router router) {
        Preconditions.checkNotNull((Object)router);
        return this.post(NeutronRouter.class, this.uri("/routers", new Object[0])).entity(router).execute();
    }

    @Override
    public Router update(Router router) {
        Preconditions.checkNotNull((Object)router);
        Preconditions.checkNotNull((Object)router.getId());
        RouterBuilder rb = NeutronRouter.builder().name(router.getName()).adminStateUp(router.isAdminStateUp()).externalGateway(router.getExternalGatewayInfo());
        List<? extends HostRoute> routes = router.getRoutes();
        if (routes != null && !routes.isEmpty()) {
            for (HostRoute hostRoute : routes) {
                rb.route(hostRoute.getDestination(), hostRoute.getNexthop());
            }
        }
        return this.put(NeutronRouter.class, this.uri("/routers/%s", router.getId())).entity(rb.build()).execute();
    }

    @Override
    public Router toggleAdminStateUp(String routerId, boolean adminStateUp) {
        Preconditions.checkNotNull((Object)routerId);
        return this.put(NeutronRouter.class, this.uri("/routers/%s", routerId)).entity(NeutronRouter.builder().adminStateUp(adminStateUp).build()).execute();
    }

    @Override
    public RouterInterface attachInterface(String routerId, AttachInterfaceType type, String portOrSubnetId) {
        Preconditions.checkNotNull((Object)routerId);
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull((Object)portOrSubnetId);
        return this.put(NeutronRouterInterface.class, this.uri("/routers/%s/add_router_interface", routerId)).entity(AddRouterInterfaceAction.create(type, portOrSubnetId)).execute();
    }

    @Override
    public RouterInterface detachInterface(String routerId, String subnetId, String portId) {
        Preconditions.checkNotNull((Object)routerId);
        Preconditions.checkState((subnetId != null || portId != null ? 1 : 0) != 0, (Object)"Either a Subnet or Port identifier must be set");
        return this.put(NeutronRouterInterface.class, this.uri("/routers/%s/remove_router_interface", routerId)).entity(new NeutronRouterInterface(subnetId, portId)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

