/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.networking.ext.VpnEndpointGroupService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.networking.domain.VpnEndpoint;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;

public class VpnEndpointGroupServiceImpl
extends BaseNetworkingServices
implements VpnEndpointGroupService {
    private static final String API_PATH = "/vpn/endpoint-groups";
    private static final String filter = "fields";

    @Override
    public VpnEndpoint create(VpnEndpoint model) {
        return this.post(VpnEndpoint.class, this.uri(API_PATH, new Object[0])).entity(model).execute();
    }

    @Override
    public List<VpnEndpoint> list(String field) {
        return this.get(VpnEndpoint.VpnEndpoints.class, this.uri(API_PATH, new Object[0])).param(filter, field).execute().getList();
    }

    @Override
    public VpnEndpoint get(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"parameter `id` should not be empty");
        return this.get(VpnEndpoint.class, this.uri("/vpn/endpoint-groups/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"parameter `id` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vpn/endpoint-groups/%s", id)).executeWithResponse());
    }

    @Override
    public VpnEndpoint update(String id, VpnEndpoint model) {
        Preconditions.checkArgument((null != model ? 1 : 0) != 0, (Object)"parameter `model` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"parameter `connectionId` should not be empty");
        return this.put(VpnEndpoint.class, this.uri("/vpn/endpoint-groups/%s", id)).entity(model).execute();
    }
}

