/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.networking.ext.FirewallPolicyService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.network.ext.FirewallPolicy;
import com.huawei.openstack4j.model.network.ext.FirewallPolicyUpdate;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.ext.AbstractNeutronFirewallPolicy;
import com.huawei.openstack4j.openstack.networking.domain.ext.FirewallRuleStrategy;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronFirewallPolicy;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronFirewallPolicyRule;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class FirewallPolicyServiceImpl
extends BaseNetworkingServices
implements FirewallPolicyService {
    @Override
    public List<? extends FirewallPolicy> list() {
        return this.get(AbstractNeutronFirewallPolicy.FirewallPolicies.class, this.uri("/fw/firewall_policies", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends FirewallPolicy> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<AbstractNeutronFirewallPolicy.FirewallPolicies> req = this.get(AbstractNeutronFirewallPolicy.FirewallPolicies.class, this.uri("/fw/firewall_policies", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public FirewallPolicy get(String firewallPolicyId) {
        Preconditions.checkNotNull((Object)firewallPolicyId);
        return this.get(NeutronFirewallPolicy.class, this.uri("/fw/firewall_policies/%s", firewallPolicyId)).execute();
    }

    @Override
    public ActionResponse delete(String firewallPolicyId) {
        Preconditions.checkNotNull((Object)firewallPolicyId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/fw/firewall_policies/%s", firewallPolicyId)).executeWithResponse());
    }

    @Override
    public FirewallPolicy create(FirewallPolicy firewallPolicy) {
        return this.post(NeutronFirewallPolicy.class, this.uri("/fw/firewall_policies", new Object[0])).entity(firewallPolicy).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public FirewallPolicy update(String firewallPolicyId, FirewallPolicyUpdate firewallPolicyUpdate) {
        Preconditions.checkNotNull((Object)firewallPolicyId);
        Preconditions.checkNotNull((Object)firewallPolicyUpdate);
        return this.put(NeutronFirewallPolicy.class, this.uri("/fw/firewall_policies/%s", firewallPolicyId)).entity(firewallPolicyUpdate).execute();
    }

    @Override
    public FirewallPolicy insertFirewallRuleInPolicy(String firewallPolicyId, String firewallRuleId, FirewallRuleStrategy.RuleInsertStrategyType type, String insertAfterOrBeforeRuleId) {
        Preconditions.checkNotNull((Object)firewallPolicyId);
        Preconditions.checkNotNull((Object)firewallRuleId);
        return this.put(NeutronFirewallPolicyRule.class, this.uri("/fw/firewall_policies/%s/insert_rule", firewallPolicyId)).entity(FirewallRuleStrategy.create(firewallRuleId, type, insertAfterOrBeforeRuleId)).execute();
    }

    @Override
    public FirewallPolicy removeFirewallRuleFromPolicy(String firewallPolicyId, String firewallRuleId) {
        Preconditions.checkNotNull((Object)firewallPolicyId);
        Preconditions.checkNotNull((Object)firewallRuleId);
        Preconditions.checkState((firewallPolicyId != null || firewallRuleId != null ? 1 : 0) != 0, (Object)"Either a Firewall Policy or Firewall Rule identifier must be set");
        return this.put(NeutronFirewallPolicyRule.class, this.uri("/fw/firewall_policies/%s/remove_rule", firewallPolicyId)).entity(FirewallRuleStrategy.remove(firewallRuleId)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

