/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.networking.ext.FirewallRuleService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.network.ext.FirewallRule;
import com.huawei.openstack4j.model.network.ext.FirewallRuleUpdate;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronFirewallRule;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class FirewallRuleServiceImpl
extends BaseNetworkingServices
implements FirewallRuleService {
    @Override
    public List<? extends FirewallRule> list() {
        return this.get(NeutronFirewallRule.FirewallRules.class, this.uri("/fw/firewall_rules", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends FirewallRule> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronFirewallRule.FirewallRules> req = this.get(NeutronFirewallRule.FirewallRules.class, this.uri("/fw/firewall_rules", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public FirewallRule get(String firewallRuleId) {
        Preconditions.checkNotNull((Object)firewallRuleId);
        return this.get(NeutronFirewallRule.class, this.uri("/fw/firewall_rules/%s", firewallRuleId)).execute();
    }

    @Override
    public ActionResponse delete(String firewallRuleId) {
        Preconditions.checkNotNull((Object)firewallRuleId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/fw/firewall_rules/%s", firewallRuleId)).executeWithResponse());
    }

    @Override
    public FirewallRule create(FirewallRule firewall) {
        return this.post(NeutronFirewallRule.class, this.uri("/fw/firewall_rules", new Object[0])).entity(firewall).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public FirewallRule update(String firewallRuleId, FirewallRuleUpdate firewallRuleUpdate) {
        Preconditions.checkNotNull((Object)firewallRuleId);
        Preconditions.checkNotNull((Object)firewallRuleUpdate);
        return this.put(NeutronFirewallRule.class, this.uri("/fw/firewall_rules/%s", firewallRuleId)).entity(firewallRuleUpdate).execute();
    }
}

