/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.networking.ext.LbPolicyV2Service;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronL7Policy;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronL7PolicyUpdate;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class LbPolicyV2ServiceImpl
extends BaseNetworkingServices
implements LbPolicyV2Service {
    private static final String API_PATH = "/lbaas/l7policies";

    @Override
    public NeutronL7Policy.NeutronL7Policies list() {
        return this.get(NeutronL7Policy.NeutronL7Policies.class, this.uri(API_PATH, new Object[0])).execute();
    }

    @Override
    public List<? extends NeutronL7Policy> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronL7Policy.NeutronL7Policies> serverInvocation = this.get(NeutronL7Policy.NeutronL7Policies.class, API_PATH);
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                serverInvocation = serverInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return serverInvocation.execute().getList();
    }

    @Override
    public NeutronL7Policy get(String policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"parameter `policyId` should not be empty");
        return this.get(NeutronL7Policy.class, this.uri("/lbaas/l7policies/%s", policyId)).execute();
    }

    @Override
    public NeutronL7Policy create(NeutronL7Policy model) {
        Preconditions.checkArgument((model != null ? 1 : 0) != 0, (Object)"parameter `L7Policy` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)model.getListenerId()) ? 1 : 0) != 0, (Object)"parameter `listernerId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)model.getAction()) ? 1 : 0) != 0, (Object)"parameter `action` should not be empty");
        return this.post(NeutronL7Policy.class, this.uri(API_PATH, new Object[0])).entity(model).execute();
    }

    @Override
    public NeutronL7Policy update(NeutronL7PolicyUpdate l7PolicyUpdate, String l7policyId) {
        Preconditions.checkArgument((l7PolicyUpdate != null ? 1 : 0) != 0, (Object)"parameter `l7PolicyUpdate` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)l7policyId) ? 1 : 0) != 0, (Object)"parameter `l7policyId` should not be empty");
        return this.put(NeutronL7Policy.class, this.uri("/lbaas/l7policies/%s", l7policyId)).entity(l7PolicyUpdate).execute();
    }

    @Override
    public ActionResponse delete(String l7policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)l7policyId) ? 1 : 0) != 0, (Object)"parameter `l7policyId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lbaas/l7policies/%s", l7policyId)).executeWithResponse());
    }
}

