/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.networking.ext.LbWhitelistV2Service;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronWhitelist;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronWhitelistUpdate;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class LbWhiteV2listServiceImpl
extends BaseNetworkingServices
implements LbWhitelistV2Service {
    private static final String API_PATH = "/lbaas/whitelists";

    @Override
    public NeutronWhitelist get(String whitelistId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)whitelistId) ? 1 : 0) != 0, (Object)"parameter `whitelistId` should not be empty");
        return this.get(NeutronWhitelist.class, this.uri("/lbaas/whitelists/%s", whitelistId)).execute();
    }

    @Override
    public NeutronWhitelist.NeutronWhitelists list() {
        return this.get(NeutronWhitelist.NeutronWhitelists.class, this.uri(API_PATH, new Object[0])).execute();
    }

    @Override
    public List<? extends NeutronWhitelist> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronWhitelist.NeutronWhitelists> serverInvocation = this.get(NeutronWhitelist.NeutronWhitelists.class, this.uri(API_PATH, new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                serverInvocation = serverInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return serverInvocation.execute().getList();
    }

    @Override
    public NeutronWhitelist create(NeutronWhitelist model) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)model.getListenerId()) ? 1 : 0) != 0, (Object)"parameter `listenerId` should not be empty");
        return this.post(NeutronWhitelist.class, this.uri(API_PATH, new Object[0])).entity(model).execute();
    }

    @Override
    public NeutronWhitelist update(NeutronWhitelistUpdate model, String whitelistId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)whitelistId) ? 1 : 0) != 0, (Object)"parameter `whitelistId` should not be empty");
        Preconditions.checkArgument((null != model ? 1 : 0) != 0, (Object)"parameter `updateModel` should not be null");
        return this.put(NeutronWhitelist.class, this.uri("/lbaas/whitelists/%s", whitelistId)).entity(model).execute();
    }

    @Override
    public ActionResponse delete(String whitelistId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)whitelistId) ? 1 : 0) != 0, (Object)"parameter `whitelistId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lbaas/whitelists/%s", whitelistId)).executeWithResponse());
    }
}

