/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.networking.ext.MemberService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.network.ext.Member;
import com.huawei.openstack4j.model.network.ext.MemberUpdate;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronMember;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class MemberServiceImpl
extends BaseNetworkingServices
implements MemberService {
    @Override
    public List<? extends Member> list() {
        return this.get(NeutronMember.Members.class, this.uri("/lb/members", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Member> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronMember.Members> req = this.get(NeutronMember.Members.class, this.uri("/lb/members", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public Member get(String memberId) {
        Preconditions.checkNotNull((Object)memberId);
        return this.get(NeutronMember.class, this.uri("/lb/members/%s", memberId)).execute();
    }

    @Override
    public ActionResponse delete(String memberId) {
        Preconditions.checkNotNull((Object)memberId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lb/members/%s", memberId)).executeWithResponse());
    }

    @Override
    public Member create(Member member) {
        Preconditions.checkNotNull((Object)member);
        return this.post(NeutronMember.class, this.uri("/lb/members", new Object[0])).entity(member).execute();
    }

    @Override
    public Member update(String memberId, MemberUpdate member) {
        Preconditions.checkNotNull((Object)memberId);
        Preconditions.checkNotNull((Object)member);
        return this.put(NeutronMember.class, this.uri("/lb/members/%s", memberId)).entity(member).execute();
    }
}

