/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.scaling.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.scaling.ScalingGroup;
import com.huawei.openstack4j.model.scaling.ScalingGroupUpdate;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import java.beans.ConstructorProperties;
import java.util.List;

public class ASAutoScalingGroupUpdate
implements ScalingGroupUpdate {
    private static final long serialVersionUID = 7168645684244117704L;
    @JsonProperty(value="scaling_group_id")
    String groupId;
    @JsonProperty(value="scaling_group_name")
    String groupName;
    @JsonProperty(value="scaling_configuration_id")
    String configId;
    @JsonProperty(value="desire_instance_number")
    Integer desireInstanceNumber;
    @JsonProperty(value="min_instance_number")
    Integer minInstanceNumber;
    @JsonProperty(value="max_instance_number")
    Integer maxInstanceNumber;
    @JsonProperty(value="cool_down_time")
    Integer coolDownTime;
    @JsonProperty(value="lb_listener_id")
    String lbListenerId;
    @JsonProperty(value="available_zones")
    List<String> availabilityZones;
    @JsonProperty(value="networks")
    List<IdResourceEntity> networks;
    @JsonProperty(value="security_groups")
    List<IdResourceEntity> securityGroups;
    @JsonProperty(value="health_periodic_audit_method")
    ScalingGroup.HealthPeriodicAuditMethod healthPeriodicAuditMethod;
    @JsonProperty(value="health_periodic_audit_time")
    Integer healthPeriodicAuditTime;
    @JsonProperty(value="instance_terminate_policy")
    ScalingGroup.InstanceTerminatePolicy instanceTerminatePolicy;
    @JsonProperty(value="notifications")
    List<String> notifications;
    @JsonProperty(value="delete_publicip")
    Boolean deletePublicip;

    public static ASAutoScalingGroupUpdate fromScalingGroup(ScalingGroup group) {
        return ASAutoScalingGroupUpdate.builder().groupName(group.getGroupName()).desireInstanceNumber(group.getDesireInstanceNumber()).minInstanceNumber(group.getMinInstanceNumber()).maxInstanceNumber(group.getMaxInstanceNumber()).coolDownTime(group.getCoolDownTime()).availabilityZones(group.getAvailabilityZones()).networks(group.getNetworks()).securityGroups(group.getSecurityGroups()).lbListenerId(group.getLbListenerId()).healthPeriodicAuditMethod(group.getHealthPeriodicAuditMethod()).healthPeriodicAuditTime(group.getHealthPeriodicAuditTime()).instanceTerminatePolicy(group.getInstanceTerminatePolicy()).configId(group.getConfigId()).notifications(group.getNotifications()).deletePublicip(group.getDeletePublicip()).build();
    }

    public static ASAutoScalingGroupUpdateBuilder builder() {
        return new ASAutoScalingGroupUpdateBuilder();
    }

    public ASAutoScalingGroupUpdateBuilder toBuilder() {
        return new ASAutoScalingGroupUpdateBuilder().groupId(this.groupId).groupName(this.groupName).configId(this.configId).desireInstanceNumber(this.desireInstanceNumber).minInstanceNumber(this.minInstanceNumber).maxInstanceNumber(this.maxInstanceNumber).coolDownTime(this.coolDownTime).lbListenerId(this.lbListenerId).availabilityZones(this.availabilityZones).networks(this.networks).securityGroups(this.securityGroups).healthPeriodicAuditMethod(this.healthPeriodicAuditMethod).healthPeriodicAuditTime(this.healthPeriodicAuditTime).instanceTerminatePolicy(this.instanceTerminatePolicy).notifications(this.notifications).deletePublicip(this.deletePublicip);
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getConfigId() {
        return this.configId;
    }

    @Override
    public Integer getDesireInstanceNumber() {
        return this.desireInstanceNumber;
    }

    @Override
    public Integer getMinInstanceNumber() {
        return this.minInstanceNumber;
    }

    @Override
    public Integer getMaxInstanceNumber() {
        return this.maxInstanceNumber;
    }

    @Override
    public Integer getCoolDownTime() {
        return this.coolDownTime;
    }

    @Override
    public String getLbListenerId() {
        return this.lbListenerId;
    }

    @Override
    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    @Override
    public List<IdResourceEntity> getNetworks() {
        return this.networks;
    }

    @Override
    public List<IdResourceEntity> getSecurityGroups() {
        return this.securityGroups;
    }

    @Override
    public ScalingGroup.HealthPeriodicAuditMethod getHealthPeriodicAuditMethod() {
        return this.healthPeriodicAuditMethod;
    }

    @Override
    public Integer getHealthPeriodicAuditTime() {
        return this.healthPeriodicAuditTime;
    }

    @Override
    public ScalingGroup.InstanceTerminatePolicy getInstanceTerminatePolicy() {
        return this.instanceTerminatePolicy;
    }

    @Override
    public List<String> getNotifications() {
        return this.notifications;
    }

    @Override
    public Boolean getDeletePublicip() {
        return this.deletePublicip;
    }

    public String toString() {
        return "ASAutoScalingGroupUpdate(groupId=" + this.getGroupId() + ", groupName=" + this.getGroupName() + ", configId=" + this.getConfigId() + ", desireInstanceNumber=" + this.getDesireInstanceNumber() + ", minInstanceNumber=" + this.getMinInstanceNumber() + ", maxInstanceNumber=" + this.getMaxInstanceNumber() + ", coolDownTime=" + this.getCoolDownTime() + ", lbListenerId=" + this.getLbListenerId() + ", availabilityZones=" + this.getAvailabilityZones() + ", networks=" + this.getNetworks() + ", securityGroups=" + this.getSecurityGroups() + ", healthPeriodicAuditMethod=" + (Object)((Object)this.getHealthPeriodicAuditMethod()) + ", healthPeriodicAuditTime=" + this.getHealthPeriodicAuditTime() + ", instanceTerminatePolicy=" + (Object)((Object)this.getInstanceTerminatePolicy()) + ", notifications=" + this.getNotifications() + ", deletePublicip=" + this.getDeletePublicip() + ")";
    }

    public ASAutoScalingGroupUpdate() {
    }

    @ConstructorProperties(value={"groupId", "groupName", "configId", "desireInstanceNumber", "minInstanceNumber", "maxInstanceNumber", "coolDownTime", "lbListenerId", "availabilityZones", "networks", "securityGroups", "healthPeriodicAuditMethod", "healthPeriodicAuditTime", "instanceTerminatePolicy", "notifications", "deletePublicip"})
    public ASAutoScalingGroupUpdate(String groupId, String groupName, String configId, Integer desireInstanceNumber, Integer minInstanceNumber, Integer maxInstanceNumber, Integer coolDownTime, String lbListenerId, List<String> availabilityZones, List<IdResourceEntity> networks, List<IdResourceEntity> securityGroups, ScalingGroup.HealthPeriodicAuditMethod healthPeriodicAuditMethod, Integer healthPeriodicAuditTime, ScalingGroup.InstanceTerminatePolicy instanceTerminatePolicy, List<String> notifications, Boolean deletePublicip) {
        this.groupId = groupId;
        this.groupName = groupName;
        this.configId = configId;
        this.desireInstanceNumber = desireInstanceNumber;
        this.minInstanceNumber = minInstanceNumber;
        this.maxInstanceNumber = maxInstanceNumber;
        this.coolDownTime = coolDownTime;
        this.lbListenerId = lbListenerId;
        this.availabilityZones = availabilityZones;
        this.networks = networks;
        this.securityGroups = securityGroups;
        this.healthPeriodicAuditMethod = healthPeriodicAuditMethod;
        this.healthPeriodicAuditTime = healthPeriodicAuditTime;
        this.instanceTerminatePolicy = instanceTerminatePolicy;
        this.notifications = notifications;
        this.deletePublicip = deletePublicip;
    }

    public static class ASAutoScalingGroupUpdateBuilder {
        private String groupId;
        private String groupName;
        private String configId;
        private Integer desireInstanceNumber;
        private Integer minInstanceNumber;
        private Integer maxInstanceNumber;
        private Integer coolDownTime;
        private String lbListenerId;
        private List<String> availabilityZones;
        private List<IdResourceEntity> networks;
        private List<IdResourceEntity> securityGroups;
        private ScalingGroup.HealthPeriodicAuditMethod healthPeriodicAuditMethod;
        private Integer healthPeriodicAuditTime;
        private ScalingGroup.InstanceTerminatePolicy instanceTerminatePolicy;
        private List<String> notifications;
        private Boolean deletePublicip;

        ASAutoScalingGroupUpdateBuilder() {
        }

        public ASAutoScalingGroupUpdateBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder desireInstanceNumber(Integer desireInstanceNumber) {
            this.desireInstanceNumber = desireInstanceNumber;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder minInstanceNumber(Integer minInstanceNumber) {
            this.minInstanceNumber = minInstanceNumber;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder maxInstanceNumber(Integer maxInstanceNumber) {
            this.maxInstanceNumber = maxInstanceNumber;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder coolDownTime(Integer coolDownTime) {
            this.coolDownTime = coolDownTime;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder lbListenerId(String lbListenerId) {
            this.lbListenerId = lbListenerId;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder availabilityZones(List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder networks(List<IdResourceEntity> networks) {
            this.networks = networks;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder securityGroups(List<IdResourceEntity> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder healthPeriodicAuditMethod(ScalingGroup.HealthPeriodicAuditMethod healthPeriodicAuditMethod) {
            this.healthPeriodicAuditMethod = healthPeriodicAuditMethod;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder healthPeriodicAuditTime(Integer healthPeriodicAuditTime) {
            this.healthPeriodicAuditTime = healthPeriodicAuditTime;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder instanceTerminatePolicy(ScalingGroup.InstanceTerminatePolicy instanceTerminatePolicy) {
            this.instanceTerminatePolicy = instanceTerminatePolicy;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder notifications(List<String> notifications) {
            this.notifications = notifications;
            return this;
        }

        public ASAutoScalingGroupUpdateBuilder deletePublicip(Boolean deletePublicip) {
            this.deletePublicip = deletePublicip;
            return this;
        }

        public ASAutoScalingGroupUpdate build() {
            return new ASAutoScalingGroupUpdate(this.groupId, this.groupName, this.configId, this.desireInstanceNumber, this.minInstanceNumber, this.maxInstanceNumber, this.coolDownTime, this.lbListenerId, this.availabilityZones, this.networks, this.securityGroups, this.healthPeriodicAuditMethod, this.healthPeriodicAuditTime, this.instanceTerminatePolicy, this.notifications, this.deletePublicip);
        }

        public String toString() {
            return "ASAutoScalingGroupUpdate.ASAutoScalingGroupUpdateBuilder(groupId=" + this.groupId + ", groupName=" + this.groupName + ", configId=" + this.configId + ", desireInstanceNumber=" + this.desireInstanceNumber + ", minInstanceNumber=" + this.minInstanceNumber + ", maxInstanceNumber=" + this.maxInstanceNumber + ", coolDownTime=" + this.coolDownTime + ", lbListenerId=" + this.lbListenerId + ", availabilityZones=" + this.availabilityZones + ", networks=" + this.networks + ", securityGroups=" + this.securityGroups + ", healthPeriodicAuditMethod=" + (Object)((Object)this.healthPeriodicAuditMethod) + ", healthPeriodicAuditTime=" + this.healthPeriodicAuditTime + ", instanceTerminatePolicy=" + (Object)((Object)this.instanceTerminatePolicy) + ", notifications=" + this.notifications + ", deletePublicip=" + this.deletePublicip + ")";
        }
    }
}

