/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.scaling.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.scaling.AutoScalingGroupInstanceService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.scaling.ScalingGroupInstance;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingGroupInstance;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingGroupInstanceBatch;
import com.huawei.openstack4j.openstack.scaling.internal.BaseAutoScalingServices;
import com.huawei.openstack4j.openstack.scaling.options.ScalingGroupInstanceListOptions;
import java.util.List;

public class AutoScalingGroupInstanceServiceImpl
extends BaseAutoScalingServices
implements AutoScalingGroupInstanceService {
    @Override
    public List<? extends ScalingGroupInstance> list(String groupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"groupId is required");
        return this.get(ASAutoScalingGroupInstance.ASAutoScalingGroupInstances.class, this.uri("/scaling_group_instance/%s/list", groupId)).execute().getList();
    }

    @Override
    public List<? extends ScalingGroupInstance> list(String groupId, ScalingGroupInstanceListOptions options) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"groupId is required");
        return this.get(ASAutoScalingGroupInstance.ASAutoScalingGroupInstances.class, this.uri("/scaling_group_instance/%s/list", groupId)).params(options.getOptions()).execute().getList();
    }

    @Override
    public ActionResponse delete(String instanceId, boolean deleteInstance) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"instanceId is required");
        String yesOrNo = deleteInstance ? "yes" : "no";
        return this.deleteWithResponse("/scaling_group_instance/", instanceId).param("instance_delete", yesOrNo).execute();
    }

    @Override
    public ActionResponse batchAdd(String groupId, List<String> instanceIds, boolean deleteInstance) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"groupId is required");
        ASAutoScalingGroupInstanceBatch entity = ASAutoScalingGroupInstanceBatch.builder().instanceIds(instanceIds).action(ASAutoScalingGroupInstanceBatch.Action.ADD.name()).build();
        return this.post(ActionResponse.class, this.uri("/scaling_group_instance/%s/action", groupId)).entity(entity).execute();
    }

    @Override
    public ActionResponse batchRemove(String groupId, List<String> instanceIds, boolean deleteInstance) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"groupId is required");
        String yesOrNo = deleteInstance ? "yes" : "no";
        ASAutoScalingGroupInstanceBatch entity = ASAutoScalingGroupInstanceBatch.builder().instanceIds(instanceIds).delete(yesOrNo).action(ASAutoScalingGroupInstanceBatch.Action.REMOVE.name()).build();
        return this.post(ActionResponse.class, this.uri("/scaling_group_instance/%s/action", groupId)).entity(entity).execute();
    }
}

