/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.scaling.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.api.scaling.AutoScalingGroupService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.scaling.ScalingGroup;
import com.huawei.openstack4j.model.scaling.ScalingGroupCreate;
import com.huawei.openstack4j.model.scaling.ScalingGroupUpdate;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingGroup;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingGroupCreate;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingGroupUpdate;
import com.huawei.openstack4j.openstack.scaling.internal.BaseAutoScalingServices;
import com.huawei.openstack4j.openstack.scaling.options.ScalingGroupListOptions;
import java.util.HashMap;
import java.util.List;

public class AutoScalingGroupServiceImpl
extends BaseAutoScalingServices
implements AutoScalingGroupService {
    @Override
    public String create(ScalingGroupCreate group) {
        Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)"group is required");
        Preconditions.checkArgument((group.getNetworks() != null && !group.getNetworks().isEmpty() ? 1 : 0) != 0, (Object)"networks is required");
        Preconditions.checkArgument((group.getSecurityGroups() != null && !group.getSecurityGroups().isEmpty() ? 1 : 0) != 0, (Object)"securityGroups is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group.getVpcId()) ? 1 : 0) != 0, (Object)"vpcId is required");
        for (IdResourceEntity network : group.getNetworks()) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)network.getId()) ? 1 : 0) != 0, (Object)"network id is required");
        }
        for (IdResourceEntity securityGroup : group.getSecurityGroups()) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)securityGroup.getId()) ? 1 : 0) != 0, (Object)"security group id is required");
        }
        ASAutoScalingGroupCreate execute = this.post(ASAutoScalingGroupCreate.class, this.uri("/scaling_group", new Object[0])).entity(group).execute();
        return execute.getGroupId();
    }

    @Override
    public List<? extends ScalingGroup> list(ScalingGroupListOptions options) {
        return this.get(ASAutoScalingGroup.ASAutoScalingGroups.class, this.uri("/scaling_group", new Object[0])).params(options.getOptions()).execute().getList();
    }

    @Override
    public List<? extends ScalingGroup> list() {
        return this.get(ASAutoScalingGroup.ASAutoScalingGroups.class, this.uri("/scaling_group", new Object[0])).execute().getList();
    }

    @Override
    public ScalingGroup get(String groupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"group id is required");
        return this.get(ASAutoScalingGroup.class, this.uri("/scaling_group/%s", groupId)).execute();
    }

    @Override
    public String update(String groupId, ScalingGroupUpdate group) {
        Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)"group is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"group id is required");
        if (group.getNetworks() != null) {
            for (IdResourceEntity network : group.getNetworks()) {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)network.getId()) ? 1 : 0) != 0, (Object)"network id is required");
            }
        }
        if (group.getSecurityGroups() != null) {
            for (IdResourceEntity securityGroup : group.getSecurityGroups()) {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)securityGroup.getId()) ? 1 : 0) != 0, (Object)"security group id is required");
            }
        }
        return this.put(ASAutoScalingGroupUpdate.class, this.uri("/scaling_group/%s", groupId)).entity(group).execute().getGroupId();
    }

    @Override
    public ActionResponse delete(String groupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"group id is required");
        return this.deleteWithResponse(this.uri("/scaling_group/%s", groupId)).execute();
    }

    @Override
    public ActionResponse resume(String groupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"group id is required");
        HashMap entity = Maps.newHashMap();
        entity.put("action", "resume");
        return this.postWithResponse(this.uri("/scaling_group/%s/action", groupId)).entity(entity).execute();
    }

    @Override
    public ActionResponse pause(String groupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"group id is required");
        HashMap entity = Maps.newHashMap();
        entity.put("action", "pause");
        return this.postWithResponse(this.uri("/scaling_group/%s/action", groupId)).entity(entity).execute();
    }
}

