/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.scaling.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.api.scaling.AutoScalingPolicyService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.scaling.ScalingPolicy;
import com.huawei.openstack4j.model.scaling.ScalingPolicyCreateUpdate;
import com.huawei.openstack4j.model.scaling.ScheduledPolicy;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingPolicy;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingPolicyCreateUpdate;
import com.huawei.openstack4j.openstack.scaling.internal.BaseAutoScalingServices;
import com.huawei.openstack4j.openstack.scaling.options.ScalingPolicyListOptions;
import java.util.HashMap;
import java.util.List;

public class AutoScalingPolicyServiceImpl
extends BaseAutoScalingServices
implements AutoScalingPolicyService {
    @Override
    public String create(ScalingPolicyCreateUpdate policy) {
        Preconditions.checkArgument((policy != null ? 1 : 0) != 0, (Object)"policy required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policy.getPolicyName()) ? 1 : 0) != 0, (Object)"policyName required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policy.getGroupId()) ? 1 : 0) != 0, (Object)"groupId required");
        Preconditions.checkArgument((policy.getPolicyType() != null ? 1 : 0) != 0, (Object)"policyType required");
        this.checkScheduledPolicyWhenPresent(policy.getScheduledPolicy());
        return this.post(ASAutoScalingPolicyCreateUpdate.class, this.uri("/scaling_policy", new Object[0])).entity(policy).execute().getPolicyId();
    }

    @Override
    public String update(ScalingPolicyCreateUpdate policy) {
        Preconditions.checkArgument((policy != null ? 1 : 0) != 0, (Object)"policy required");
        String policyId = policy.getPolicyId();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"policyId required");
        return this.put(ASAutoScalingPolicyCreateUpdate.class, this.uri("/scaling_policy/%s", policyId)).entity(this.resetPolicyId((ASAutoScalingPolicyCreateUpdate)policy)).execute().getPolicyId();
    }

    private ScalingPolicyCreateUpdate resetPolicyId(ASAutoScalingPolicyCreateUpdate policy) {
        return policy.toBuilder().policyId(null).build();
    }

    @Override
    public List<? extends ScalingPolicy> list(String groupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"groupId required");
        return this.get(ASAutoScalingPolicy.ASAutoScalingPolicys.class, this.uri("/scaling_policy/%s/list", groupId)).execute().getList();
    }

    @Override
    public List<? extends ScalingPolicy> list(String groupId, ScalingPolicyListOptions options) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"groupId required");
        return this.get(ASAutoScalingPolicy.ASAutoScalingPolicys.class, this.uri("/scaling_policy/%s/list", groupId)).params(options.getOptions()).execute().getList();
    }

    @Override
    public ScalingPolicy get(String policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"policyId required");
        return this.get(ASAutoScalingPolicy.class, this.uri("/scaling_policy/%s", policyId)).execute();
    }

    @Override
    public ActionResponse execute(String policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"policyId required");
        HashMap entity = Maps.newHashMap();
        entity.put("action", "execute");
        return this.post(ActionResponse.class, this.uri("/scaling_policy/%s/action", policyId)).entity(entity).execute();
    }

    @Override
    public ActionResponse resume(String policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"policyId required");
        HashMap entity = Maps.newHashMap();
        entity.put("action", "resume");
        return this.post(ActionResponse.class, this.uri("/scaling_policy/%s/action", policyId)).entity(entity).execute();
    }

    @Override
    public ActionResponse pause(String policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"policyId required");
        HashMap entity = Maps.newHashMap();
        entity.put("action", "pause");
        return this.post(ActionResponse.class, this.uri("/scaling_policy/%s/action", policyId)).entity(entity).execute();
    }

    @Override
    public ActionResponse delete(String policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"policyId required");
        return this.deleteWithResponse(this.uri("/scaling_policy/%s", policyId)).execute();
    }

    private void checkScheduledPolicyWhenPresent(ScheduledPolicy scheduledPolicy) {
        if (scheduledPolicy != null) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)scheduledPolicy.getLaunchTime()) ? 1 : 0) != 0, (Object)"launchTime required");
        }
    }
}

