/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.senlin.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.senlin.SenlinProfileService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.senlin.Profile;
import com.huawei.openstack4j.model.senlin.ProfileCreate;
import com.huawei.openstack4j.openstack.senlin.domain.SenlinProfile;
import com.huawei.openstack4j.openstack.senlin.internal.BaseSenlinServices;
import java.util.List;

public class SenlinProfileServiceImpl
extends BaseSenlinServices
implements SenlinProfileService {
    @Override
    public List<? extends Profile> list() {
        return this.get(SenlinProfile.Profile.class, this.uri("/profiles", new Object[0])).execute().getList();
    }

    @Override
    public Profile create(ProfileCreate newProfile) {
        Preconditions.checkNotNull((Object)newProfile);
        return this.post(SenlinProfile.class, this.uri("/profiles", new Object[0])).entity(newProfile).execute();
    }

    @Override
    public Profile get(String policyID) {
        Preconditions.checkNotNull((Object)policyID);
        return this.get(SenlinProfile.class, this.uri("/profiles/%s", policyID)).execute();
    }

    @Override
    public Profile update(String policyID, ProfileCreate newPolicy) {
        Preconditions.checkNotNull((Object)policyID);
        Preconditions.checkNotNull((Object)newPolicy);
        return this.patch(SenlinProfile.class, this.uri("/profiles/%s", policyID)).entity(newPolicy).execute();
    }

    @Override
    public ActionResponse delete(String policyID) {
        Preconditions.checkNotNull((Object)policyID);
        return this.deleteWithResponse(this.uri("/profiles/%s", policyID)).execute();
    }
}

