/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.block.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.api.storage.BlockVolumeBackupPolicyService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.storage.block.VolumeBackupPolicy;
import com.huawei.openstack4j.model.storage.block.VolumeBackupPolicyBackupTask;
import com.huawei.openstack4j.model.storage.block.VolumeBackupPolicyResource;
import com.huawei.openstack4j.model.storage.block.options.BakcupTaskListOptions;
import com.huawei.openstack4j.openstack.storage.block.domain.VBSVolumeBackupPolicy;
import com.huawei.openstack4j.openstack.storage.block.domain.VBSVolumeBackupPolicyBackupTask;
import com.huawei.openstack4j.openstack.storage.block.domain.VBSVolumeBackupPolicyResource;
import com.huawei.openstack4j.openstack.storage.block.domain.VBSVolumeBackupPolicyResourceActionResult;
import com.huawei.openstack4j.openstack.storage.block.domain.VBSVolumeBackupScheduledPolicy;
import com.huawei.openstack4j.openstack.storage.block.internal.BaseVolumeBackupServices;
import java.util.HashMap;
import java.util.List;

public class VBSVolumeBackupPolicyService
extends BaseVolumeBackupServices
implements BlockVolumeBackupPolicyService {
    @Override
    public VolumeBackupPolicy create(VolumeBackupPolicy policy) {
        Preconditions.checkNotNull((Object)policy, (Object)"parameter `policy` should not be null");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)policy.getName()) ? 1 : 0) != 0, (Object)"parameter `policy.name` should not be null");
        VolumeBackupPolicy.VolumeBackupScheduledPolicy scheduledPolicy = policy.getScheduledPolicy();
        this.checkScheduledPolicy(scheduledPolicy);
        return this.post(VBSVolumeBackupPolicy.class, "/backuppolicy").entity(policy).execute();
    }

    public void checkScheduledPolicy(VolumeBackupPolicy.VolumeBackupScheduledPolicy scheduledPolicy) {
        Preconditions.checkNotNull((Object)scheduledPolicy);
        Preconditions.checkNotNull((Object)scheduledPolicy.getFrequency());
        Preconditions.checkNotNull((Object)scheduledPolicy.getMaxBackupAmount());
        Preconditions.checkNotNull((Object)scheduledPolicy.getRetainFirstBackupOfCurrentMonth());
        Preconditions.checkState((!Strings.isNullOrEmpty((String)scheduledPolicy.getStartTime()) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)scheduledPolicy.getStatus()));
    }

    @Override
    public List<? extends VolumeBackupPolicy> list() {
        return this.get(VBSVolumeBackupPolicy.VolumeBackupPolicies.class, "/backuppolicy").execute().getList();
    }

    @Override
    public VolumeBackupPolicy update(VolumeBackupPolicy updated) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)updated.getId()) ? 1 : 0) != 0, (Object)"parameter `policy.id` should not be null");
        return this.put(VBSVolumeBackupPolicy.class, "/backuppolicy", "/", updated.getId()).entity(updated).execute();
    }

    @Override
    public ActionResponse delete(String backupPolicyId) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)backupPolicyId) ? 1 : 0) != 0, (Object)"parameter `backupPolicyId` should not be null");
        return this.deleteWithResponse("/backuppolicy", "/", backupPolicyId).execute();
    }

    @Override
    public ActionResponse execute(String backupPolicyId) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)backupPolicyId) ? 1 : 0) != 0, (Object)"parameter `backupPolicyId` should not be null");
        return this.postWithResponse("/backuppolicy", "/", backupPolicyId, "/action").execute();
    }

    @Override
    public VolumeBackupPolicy enable(String backupPolicyId) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)backupPolicyId) ? 1 : 0) != 0, (Object)"parameter `backupPolicyId` should not be null");
        VBSVolumeBackupScheduledPolicy scheduledPolicy = VBSVolumeBackupScheduledPolicy.builder().status(VolumeBackupPolicy.VolumeBackupPolicyStatus.ON).build();
        VBSVolumeBackupPolicy policy = VBSVolumeBackupPolicy.builder().id(backupPolicyId).scheduledPolicy(scheduledPolicy).build();
        return this.update(policy);
    }

    @Override
    public VolumeBackupPolicy disable(String backupPolicyId) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)backupPolicyId) ? 1 : 0) != 0);
        VBSVolumeBackupScheduledPolicy scheduledPolicy = VBSVolumeBackupScheduledPolicy.builder().status(VolumeBackupPolicy.VolumeBackupPolicyStatus.OFF).build();
        VBSVolumeBackupPolicy policy = VBSVolumeBackupPolicy.builder().id(backupPolicyId).scheduledPolicy(scheduledPolicy).build();
        return this.update(policy);
    }

    @Override
    public VolumeBackupPolicyResource.VolumeBackupPolicyResourceActionResult linkResources(String backupPolicyId, List<String> resourceIds) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)backupPolicyId) ? 1 : 0) != 0, (Object)"parameter `backupPolicyId` should not be null");
        Preconditions.checkNotNull(resourceIds, (Object)"Parameter `resourceIds` should not be null");
        Preconditions.checkState((resourceIds.size() > 0 ? 1 : 0) != 0, (Object)"Parameter `resourceIds` should not be empty");
        _VBSVolumeBackupPolicyResources resources = new _VBSVolumeBackupPolicyResources();
        resources.setBackupPolicyId(backupPolicyId);
        for (String resourceId : resourceIds) {
            VBSVolumeBackupPolicyResource resource = VBSVolumeBackupPolicyResource.builder().id(resourceId).type("volume").build();
            resources.addResource(resource);
        }
        return this.post(VBSVolumeBackupPolicyResourceActionResult.class, "/backuppolicyresources").entity(resources).execute();
    }

    @Override
    public VolumeBackupPolicyResource.VolumeBackupPolicyResourceActionResult unlinkResources(String backupPolicyId, List<String> resourceIds) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)backupPolicyId) ? 1 : 0) != 0, (Object)"Parameter `backupPolicyId` should not be empty");
        Preconditions.checkNotNull(resourceIds, (Object)"Parameter `resourceIds` should not be null");
        Preconditions.checkState((resourceIds.size() > 0 ? 1 : 0) != 0, (Object)"Parameter `resourceIds` should not be empty");
        _VBSVolumeBackupPolicyResources resources = new _VBSVolumeBackupPolicyResources();
        for (String resourceId : resourceIds) {
            VBSVolumeBackupPolicyResource resource = VBSVolumeBackupPolicyResource.builder().id(resourceId).build();
            resources.addResource(resource);
        }
        return this.post(VBSVolumeBackupPolicyResourceActionResult.class, "/backuppolicyresources/", backupPolicyId, "/deleted_resources").entity(resources).execute();
    }

    @Override
    public List<? extends VolumeBackupPolicyBackupTask> tasks(String policyId, BakcupTaskListOptions options) {
        HashMap params = options != null ? options.getOptions() : new HashMap();
        return this.get(VBSVolumeBackupPolicyBackupTask.VolumeBackupPolicyBackupTasks.class, "/backuppolicy", "/", policyId, "/backuptasks").params(params).execute().getList();
    }

    private static class _VBSVolumeBackupPolicyResources {
        @JsonProperty(value="backup_policy_id")
        String backupPolicyId;
        @JsonProperty(value="resources")
        private List<VBSVolumeBackupPolicyResource> resources = Lists.newArrayList();

        private _VBSVolumeBackupPolicyResources() {
        }

        public String getBackupPolicyId() {
            return this.backupPolicyId;
        }

        public void addResource(VBSVolumeBackupPolicyResource resource) {
            this.resources.add(resource);
        }

        public void setBackupPolicyId(String backupPolicyId) {
            this.backupPolicyId = backupPolicyId;
        }

        public List<VBSVolumeBackupPolicyResource> getResources() {
            return this.resources;
        }

        public void setResources(List<VBSVolumeBackupPolicyResource> resources) {
            this.resources = resources;
        }
    }
}

