/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.block.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.openstack.storage.block.domain.Sort;
import java.util.Map;

public class VolumeListOptions {
    private Map<String, Object> options = Maps.newHashMap();

    private VolumeListOptions() {
    }

    private VolumeListOptions add(String key, Object value) {
        if (value != null) {
            this.options.put(key, value);
        }
        return this;
    }

    public static VolumeListOptions create() {
        return new VolumeListOptions();
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public VolumeListOptions marker(String marker) {
        return this.add("marker", marker);
    }

    public VolumeListOptions name(String name) {
        return this.add("name", name);
    }

    public VolumeListOptions limit(Integer limit) {
        return this.add("limit", limit);
    }

    public VolumeListOptions sortKey(String sortKey) {
        return this.add("sort_key", sortKey);
    }

    public VolumeListOptions sortDir(Sort sort) {
        Preconditions.checkArgument((sort != null ? 1 : 0) != 0, (Object)"`sort` is required");
        return this.add("sort_dir", sort.name().toLowerCase());
    }

    public VolumeListOptions offset(Integer offset) {
        return this.add("offset", offset);
    }

    public VolumeListOptions status(String status) {
        return this.add("status", status);
    }

    public VolumeListOptions metadata(String metadata) {
        return this.add("metadata", metadata);
    }

    public VolumeListOptions availabilityZone(String az) {
        return this.add("availability_zone", az);
    }

    public VolumeListOptions changesSince(String since) {
        return this.add("changes_since", since);
    }
}

