/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.telemetry.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.telemetry.EventService;
import com.huawei.openstack4j.model.telemetry.Event;
import com.huawei.openstack4j.model.telemetry.EventCriteria;
import com.huawei.openstack4j.model.telemetry.Trait;
import com.huawei.openstack4j.model.telemetry.TraitDescription;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.telemetry.domain.CeilometerEvent;
import com.huawei.openstack4j.openstack.telemetry.domain.CeilometerTrait;
import com.huawei.openstack4j.openstack.telemetry.domain.CeilometerTraitDescription;
import com.huawei.openstack4j.openstack.telemetry.internal.BaseTelemetryServices;
import java.util.List;

public class EventServiceImpl
extends BaseTelemetryServices
implements EventService {
    private static final String FIELD = "q.field";
    private static final String OPER = "q.op";
    private static final String VALUE = "q.value";
    private static final String LIMIT = "limit";

    @Override
    public List<? extends Event> list(EventCriteria eventCriteria) {
        BaseOpenStackService.Invocation<CeilometerEvent[]> invocation = this.get(CeilometerEvent[].class, this.uri("/events", new Object[0]));
        if (eventCriteria != null && !eventCriteria.getCriteriaParams().isEmpty()) {
            for (EventCriteria.NameOpValue c : eventCriteria.getCriteriaParams()) {
                invocation.param(FIELD, c.getField());
                invocation.param(OPER, c.getOperator().getQueryValue());
                invocation.param(VALUE, c.getValue());
            }
        }
        CeilometerEvent[] events = invocation.execute();
        return this.wrapList(events);
    }

    @Override
    public List<? extends Event> list(EventCriteria eventCriteria, int limit) {
        BaseOpenStackService.Invocation<CeilometerEvent[]> invocation = this.get(CeilometerEvent[].class, this.uri("/events", new Object[0]));
        if (eventCriteria != null && !eventCriteria.getCriteriaParams().isEmpty()) {
            for (EventCriteria.NameOpValue c : eventCriteria.getCriteriaParams()) {
                invocation.param(FIELD, c.getField());
                invocation.param(OPER, c.getOperator().getQueryValue());
                invocation.param(VALUE, c.getValue());
            }
        }
        invocation.param(LIMIT, limit);
        CeilometerEvent[] events = invocation.execute();
        return this.wrapList(events);
    }

    @Override
    public Event get(String messageId) {
        Preconditions.checkNotNull((Object)messageId);
        return this.get(CeilometerEvent.class, this.uri("/events/%s", messageId)).execute();
    }

    @Override
    public List<String> listEventTypes() {
        String[] eventTypes = this.get(String[].class, this.uri("/event_types", new Object[0])).execute();
        return this.wrapList(eventTypes);
    }

    @Override
    public List<? extends TraitDescription> listTraitDescriptions(String eventType) {
        Preconditions.checkNotNull((Object)eventType);
        CeilometerTraitDescription[] traitDescriptions = this.get(CeilometerTraitDescription[].class, this.uri("/event_types/%s/traits", eventType)).execute();
        return this.wrapList(traitDescriptions);
    }

    @Override
    public List<? extends Trait> listTraits(String eventType, String traitName) {
        Preconditions.checkNotNull((Object)eventType);
        Preconditions.checkNotNull((Object)traitName);
        CeilometerTrait[] traits = this.get(CeilometerTrait[].class, this.uri("/event_types/%s/traits/%s", eventType, traitName)).execute();
        return this.wrapList(traits);
    }
}

